/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.camelcases;

import com.cenqua.fisheye.lucene.TokenStreamTestUtils;
import com.cenqua.fisheye.lucene.camelcases.CamelCaseAnalyser;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.junit.Test;

public class CamelCaseAnalyserTest {
    private static final Object[][] EXPECTED = new Object[][]{{"AbstractLuceneFactory.java", new String[]{"abstract", "lucene", "factory", ".java"}}, {"Lucene30", new String[]{"lucene", "30"}}, {"Lucene30.properties", new String[]{"lucene", "30", ".properties"}}, {"index-all", new String[]{"index", "all"}}, {"index-all.xml", new String[]{"index", "all", ".xml"}}, {"getLDAPConfig.cfg", new String[]{"get", "ldap", "config", ".cfg"}}, {"getLDAPConfig", new String[]{"get", "ldap", "config"}}, {".properties", new String[]{".properties"}}};
    private static final Object[][] EXPECTED_COMBINATIONS = new Object[][]{{"AbstractLuceneFactory.java", new String[]{"abstractlucene", "abstractlucenefactory", "abstractlucenefactory.java", "lucenefactory", "lucenefactory.java", "factory.java"}}, {"Lucene30", new String[]{"lucene30"}}, {"Lucene30.properties", new String[]{"lucene30", "lucene30.properties", "30.properties"}}, {"index-all", new String[]{"indexall"}}, {"index-all.xml", new String[]{"indexall", "indexall.xml", "all.xml"}}, {"getLDAPConfig.cfg", new String[]{"getldap", "getldapconfig", "getldapconfig.cfg", "ldapconfig", "ldapconfig.cfg", "config.cfg"}}, {"getLDAPConfig", new String[]{"getldap", "getldapconfig", "ldapconfig"}}};
    private static final Object[][] OFFSETS = new Object[][]{{"CamelCaseName.java", new int[]{0, 5, 5, 9, 9, 13, 13, 18}}, {"CamelCASEName.java", new int[]{0, 5, 5, 9, 9, 13, 13, 18}}, {"CAMELCaseName.java", new int[]{0, 5, 5, 9, 9, 13, 13, 18}}, {"CAMELCaseNAME.java", new int[]{0, 5, 5, 9, 9, 13, 13, 18}}, {"CamelCaseName-java", new int[]{0, 5, 5, 9, 9, 13, 14, 18}}, {"CAMELCaseNAME-java", new int[]{0, 5, 5, 9, 9, 13, 14, 18}}, {"camel", new int[]{0, 5}}, {"Camel", new int[]{0, 5}}, {"CAMEL", new int[]{0, 5}}, {".properties", new int[]{0, 11}}};
    private static final Object[][] OFFSETS_WITH_COMBINATIONS = new Object[][]{{"CamelCaseName.java", new int[]{0, 9, 0, 13, 0, 18, 5, 13, 5, 18, 9, 18}}, {"CamelCASEName.java", new int[]{0, 9, 0, 13, 0, 18, 5, 13, 5, 18, 9, 18}}, {"CAMELCaseName.java", new int[]{0, 9, 0, 13, 0, 18, 5, 13, 5, 18, 9, 18}}, {"CAMELCaseNAME.java", new int[]{0, 9, 0, 13, 0, 18, 5, 13, 5, 18, 9, 18}}, {"camel", new int[0]}, {"Camel", new int[0]}, {"CAMEL", new int[0]}, {".properties", new int[0]}};

    @Test
    public void testTokenStream() throws Exception {
        CamelCaseAnalyser analyser = new CamelCaseAnalyser(false);
        for (Object[] testdata : EXPECTED) {
            String word = (String)testdata[0];
            String[] expectedTokens = (String[])testdata[1];
            TokenStream stream = analyser.tokenStream("field", (Reader)new StringReader((String)testdata[0]));
            TokenStreamTestUtils.assertStreamEquals(stream, word, expectedTokens);
        }
    }

    @Test
    public void testTokenStreamWithCombinations() throws Exception {
        CamelCaseAnalyser analyser = new CamelCaseAnalyser(true);
        for (Object[] testdata : EXPECTED_COMBINATIONS) {
            String word = (String)testdata[0];
            String[] expectedTokens = (String[])testdata[1];
            TokenStream stream = analyser.tokenStream("field", (Reader)new StringReader((String)testdata[0]));
            TokenStreamTestUtils.assertStreamEquals(stream, word, expectedTokens);
        }
    }

    @Test
    public void testTokenStreamOffsets() throws Exception {
        CamelCaseAnalyser analyser = new CamelCaseAnalyser(false);
        for (Object[] testdata : OFFSETS) {
            String word = (String)testdata[0];
            int[] expectedOffsets = (int[])testdata[1];
            TokenStream stream = analyser.tokenStream("field", (Reader)new StringReader(word));
            TokenStreamTestUtils.assertOffsetEquals(stream, word.toLowerCase(), expectedOffsets);
        }
    }

    @Test
    public void testTokenStreamOffsetsWithCombinations() throws Exception {
        CamelCaseAnalyser analyser = new CamelCaseAnalyser(true);
        for (Object[] testdata : OFFSETS_WITH_COMBINATIONS) {
            String word = (String)testdata[0];
            int[] expectedOffsets = (int[])testdata[1];
            TokenStream stream = analyser.tokenStream("field", (Reader)new StringReader(word));
            TokenStreamTestUtils.assertOffsetEquals(stream, word.toLowerCase(), expectedOffsets, true);
        }
    }
}

