/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.junit.Assert;

public final class TokenStreamTestUtils {
    public static void assertStreamEquals(TokenStream stream, String word, String[] expectedTokens) throws IOException {
        TermAttribute attribute = (TermAttribute)stream.getAttribute(TermAttribute.class);
        for (String token : expectedTokens) {
            String message = "expected token: " + token + " (input: " + word + ")";
            Assert.assertTrue((String)message, (boolean)stream.incrementToken());
            Assert.assertEquals((String)message, (Object)token, (Object)attribute.term());
        }
        TokenStreamTestUtils.assertEndOfStream(stream);
    }

    public static void assertOffsetEquals(TokenStream stream, String word, int[] expectedOffsets) throws IOException {
        TokenStreamTestUtils.assertOffsetEquals(stream, word, expectedOffsets, false);
    }

    public static void assertOffsetEquals(TokenStream stream, String word, int[] expectedOffsets, boolean ignoreNonAlphaNumericChars) throws IOException {
        TermAttribute terms = (TermAttribute)stream.getAttribute(TermAttribute.class);
        OffsetAttribute offsets = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
        for (int i = 0; i < expectedOffsets.length; i += 2) {
            String expected = word.substring(expectedOffsets[i], expectedOffsets[i + 1]);
            if (ignoreNonAlphaNumericChars) {
                expected = expected.replaceAll("[\\W&&[^\\.]]", "");
            }
            Assert.assertTrue((String)("Token not found: " + expected), (boolean)stream.incrementToken());
            Assert.assertEquals((String)("Invalid start offset for token: <" + expected + '>'), (long)expectedOffsets[i], (long)offsets.startOffset());
            Assert.assertEquals((String)("Invalid end offset for token: <" + expected + '>'), (long)expectedOffsets[i + 1], (long)offsets.endOffset());
            Assert.assertEquals((Object)expected, (Object)terms.term());
        }
        TokenStreamTestUtils.assertEndOfStream(stream);
    }

    private static void assertEndOfStream(TokenStream stream) throws IOException {
        TermAttribute attribute = (TermAttribute)stream.getAttribute(TermAttribute.class);
        LinkedList<String> remainingTokens = new LinkedList<String>();
        while (stream.incrementToken()) {
            remainingTokens.add(attribute.term());
        }
        Assert.assertTrue((String)("Unfinished stream: unexpected tokens: " + remainingTokens), (boolean)remainingTokens.isEmpty());
    }
}

