/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.lucene.TermDocVistor;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.rep.DbException;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.Before;
import org.junit.Test;

public final class TermDocVistorTest {
    private RAMDirectory d = new RAMDirectory();
    private IndexReader reader;

    @Before
    public void setUp() throws Exception {
        IndexWriter w = new DefaultIndexWriterFactory().create((Directory)this.d, (Analyzer)new StandardAnalyzer(LuceneConnection.VERSION), true);
        Document doc = new Document();
        doc.add((Fieldable)LuceneHelper.Keyword((String)"f", (String)"aaa"));
        w.addDocument(doc);
        doc = new Document();
        doc.add((Fieldable)LuceneHelper.Keyword((String)"f", (String)"aab"));
        w.addDocument(doc);
        doc = new Document();
        doc.add((Fieldable)LuceneHelper.Keyword((String)"f", (String)"aab"));
        w.addDocument(doc);
        doc = new Document();
        doc.add((Fieldable)LuceneHelper.Keyword((String)"f", (String)"aac"));
        w.addDocument(doc);
        doc = new Document();
        doc.add((Fieldable)LuceneHelper.Keyword((String)"f", (String)"aac"));
        w.addDocument(doc);
        doc = new Document();
        doc.add((Fieldable)LuceneHelper.Keyword((String)"f", (String)"bbb"));
        w.addDocument(doc);
        w.close();
        this.reader = IndexReader.open((Directory)this.d);
    }

    @Test
    public void testVisitingWithEnd() throws Exception {
        class MyVisitor
        implements TermDocVistor.Visitor {
            int termCount;
            int docCount;

            MyVisitor() {
            }

            public boolean visitTerm(Term t) throws IOException, DbException {
                ++this.termCount;
                return true;
            }

            public boolean visitDoc(int docId) throws IOException, DbException {
                ++this.docCount;
                return true;
            }
        }
        MyVisitor v = new MyVisitor();
        TermDocVistor.visitTermDocs((IndexReader)this.reader, (Term)new Term("f", "aab"), (Term)new Term("f", "aac"), (TermDocVistor.Visitor)v);
        Assert.assertEquals((int)2, (int)v.termCount);
        Assert.assertEquals((int)4, (int)v.docCount);
    }
}

