/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.PathAnalyzer;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.junit.Assert;
import org.junit.Test;

public class PathAnalyzerTest {
    @Test
    public void testUnixPath() throws Exception {
        PathAnalyzer analyser = new PathAnalyzer();
        String input = "/test/Foobar.txt";
        TokenStream tokenStream = analyser.tokenStream("any", (Reader)new StringReader(input));
        TermAttribute term = (TermAttribute)tokenStream.getAttribute(TermAttribute.class);
        tokenStream.incrementToken();
        Assert.assertEquals((Object)"/", (Object)term.term());
        tokenStream.incrementToken();
        Assert.assertEquals((Object)"test", (Object)term.term());
        tokenStream.incrementToken();
        Assert.assertEquals((Object)"Foobar.txt", (Object)term.term());
        tokenStream.close();
    }

    @Test
    public void testWindowPath() throws Exception {
        PathAnalyzer analyser = new PathAnalyzer();
        String input = "C:\\test\\Foobar.txt";
        TokenStream tokenStream = analyser.tokenStream("any", (Reader)new StringReader(input));
        TermAttribute term = (TermAttribute)tokenStream.getAttribute(TermAttribute.class);
        tokenStream.incrementToken();
        Assert.assertEquals((Object)"/", (Object)term.term());
        tokenStream.incrementToken();
        Assert.assertEquals((Object)"C:\\test\\Foobar.txt", (Object)term.term());
        tokenStream.close();
    }
}

