/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.LuceneHelper;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneHelperTest {
    public static final String ID = "id";
    public static final String EVEN = "even";
    private Function<Integer, Document> documentProvider = docId -> {
        Document document = new Document();
        document.add((Fieldable)new Field(ID, String.valueOf(docId), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field(EVEN, String.valueOf(docId % 2), Field.Store.YES, Field.Index.NOT_ANALYZED));
        return document;
    };
    private IndexWriter indexWriter;
    private IndexSearcher indexSearcher;
    private IndexWriterConfig writerConfig;

    @Before
    public void setUp() throws Exception {
        RAMDirectory directory = new RAMDirectory();
        this.writerConfig = new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new KeywordAnalyzer());
        this.indexWriter = new IndexWriter((Directory)directory, this.writerConfig);
    }

    private void generate(Function<Integer, Document> documentSupplier, int first, int limit) throws IOException {
        for (int i = first; i < limit; ++i) {
            Document document = (Document)documentSupplier.apply((Object)i);
            this.indexWriter.addDocument(document);
        }
        this.indexWriter.commit();
        this.indexSearcher = new IndexSearcher(this.indexWriter.getReader());
    }

    @Test
    public void testFormatTimestamp() throws Exception {
        GregorianCalendar c = new GregorianCalendar(2011, 3, 7, 9, 17, 36);
        c.set(14, 523);
        Assert.assertEquals((Object)LuceneHelper.getTimestampFormat().format(c.getTime()), (Object)LuceneHelper.formatTimestamp((Date)c.getTime()));
    }

    @Test
    public void testCollectSearchResultsInBatches_withoutSort() throws Exception {
        this.generate(this.documentProvider, 0, 1000);
        List<Integer> ids = this.collectIdsInBatches(new CollectInBatchesCriteriaBuilder().query((Query)new TermQuery(new Term(EVEN, "0"))).limit(5).batchSize(2).build());
        Assert.assertThat(ids, (Matcher)Matchers.contains((Object[])new Integer[]{0, 2, 4, 6, 8}));
    }

    @Test
    public void testCollectSearchResultsInBatches_withSort() throws Exception {
        this.generate(this.documentProvider, 0, 1000);
        List<Integer> ids = this.collectIdsInBatches(new CollectInBatchesCriteriaBuilder().query((Query)new TermQuery(new Term(EVEN, "0"))).sort(new Sort(new SortField(ID, 4, true))).limit(5).batchSize(2).build());
        Assert.assertThat(ids, (Matcher)Matchers.contains((Object[])new Integer[]{998, 996, 994, 992, 990}));
    }

    @Test
    public void testCollectSearchResultsInBatches_withoutLimitButWithPredicate() throws Exception {
        this.generate(this.documentProvider, 0, 1000);
        List<Integer> ids = this.collectIdsInBatches(new CollectInBatchesCriteriaBuilder().query((Query)new TermQuery(new Term(EVEN, "0"))).batchSize(2).collectFilter((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(10))).continuePredicate((Matcher<Integer>)Matchers.lessThan((Comparable)Integer.valueOf(20))).build());
        Assert.assertThat(ids, (Matcher)Matchers.contains((Object[])new Integer[]{12, 14, 16, 18}));
    }

    private List<Integer> collectIdsInBatches(CollectInBatchesCriteria criteria) throws IOException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        LuceneHelper.collectSearchResultsInBatches((IndexSearcher)this.indexSearcher, (Query)criteria.getQuery(), (Sort)criteria.getSort(), (Integer)criteria.getLimit(), (int)criteria.getBatchSize(), (indexSearcher1, scoreDoc) -> {
            boolean continues;
            Document document = indexSearcher1.doc(scoreDoc.doc);
            int id = Integer.parseInt(document.get(ID));
            boolean bl = continues = criteria.getContinuePredicate() == null || criteria.getContinuePredicate().matches((Object)id);
            if (continues && (criteria.getCollectFilter() == null || criteria.getCollectFilter().matches((Object)id))) {
                ids.add(id);
            }
            return continues;
        });
        return ids;
    }

    private static class CollectInBatchesCriteriaBuilder {
        private Query query;
        private Sort sort;
        private Integer limit;
        private int batchSize;
        private Matcher<Integer> collectFilter;
        private Matcher<Integer> continuePredicate;

        private CollectInBatchesCriteriaBuilder() {
        }

        public CollectInBatchesCriteriaBuilder query(Query query) {
            this.query = query;
            return this;
        }

        public CollectInBatchesCriteriaBuilder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public CollectInBatchesCriteriaBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public CollectInBatchesCriteriaBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public CollectInBatchesCriteriaBuilder collectFilter(Matcher<Integer> collectFilter) {
            this.collectFilter = collectFilter;
            return this;
        }

        public CollectInBatchesCriteriaBuilder continuePredicate(Matcher<Integer> continuePredicate) {
            this.continuePredicate = continuePredicate;
            return this;
        }

        public CollectInBatchesCriteria build() {
            return new CollectInBatchesCriteria(this.query, this.sort, this.limit, this.batchSize, this.collectFilter, this.continuePredicate);
        }
    }

    private static class CollectInBatchesCriteria {
        private final Query query;
        private final Sort sort;
        private final Integer limit;
        private final int batchSize;
        private final Matcher<Integer> collectFilter;
        private final Matcher<Integer> continuePredicate;

        private CollectInBatchesCriteria(Query query, Sort sort, Integer limit, int batchSize, Matcher<Integer> collectFilter, Matcher<Integer> continuePredicate) {
            this.query = query;
            this.sort = sort;
            this.limit = limit;
            this.batchSize = batchSize;
            this.collectFilter = collectFilter;
            this.continuePredicate = continuePredicate;
        }

        public Query getQuery() {
            return this.query;
        }

        public Sort getSort() {
            return this.sort;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public Matcher<Integer> getCollectFilter() {
            return this.collectFilter;
        }

        public Matcher<Integer> getContinuePredicate() {
            return this.continuePredicate;
        }
    }
}

