/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.LongField;
import junit.framework.Assert;
import org.junit.Test;

public final class LongFieldTest {
    @Test
    public void testNearZero() {
        for (int i = -100; i <= 100; ++i) {
            for (int j = -100; j <= 100; ++j) {
                LongFieldTest.subtestTwoLongs(i, j);
            }
        }
    }

    @Test
    public void testMax() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)LongField.stringToLong((String)"01y2p0ij32e8e7"));
        Assert.assertEquals((String)"01y2p0ij32e8e7", (String)LongField.longToString((long)Long.MAX_VALUE));
        for (long l = Long.MAX_VALUE; l > 9223372036854765807L; --l) {
            LongFieldTest.subtestTwoLongs(l, l - 1L);
        }
    }

    @Test
    public void testMin() {
        Assert.assertEquals((long)Long.MIN_VALUE, (long)LongField.stringToLong((String)"-0000000000000"));
        Assert.assertEquals((String)"-0000000000000", (String)LongField.longToString((long)Long.MIN_VALUE));
        for (long l = Long.MIN_VALUE; l < -9223372036854765808L; ++l) {
            LongFieldTest.subtestTwoLongs(l, l + 1L);
        }
    }

    private static void subtestTwoLongs(long i, long j) {
        String a = LongField.longToString((long)i);
        String b = LongField.longToString((long)j);
        Assert.assertEquals((int)LongField.STR_SIZE, (int)a.length());
        Assert.assertEquals((int)LongField.STR_SIZE, (int)b.length());
        if (i < j) {
            Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        } else if (i > j) {
            Assert.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)a, (String)b);
        }
        long i2 = LongField.stringToLong((String)a);
        long j2 = LongField.stringToLong((String)b);
        Assert.assertEquals((long)i, (long)i2);
        Assert.assertEquals((long)j, (long)j2);
    }
}

