/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.atlassian.fecru.search.common.lucene.LuceneTestUtils;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.search.Query;
import org.junit.Test;

public final class FreeTextAnalyzerTest {
    @Test
    public void testSimple() throws IOException {
        FreeTextAnalyzer mine = new FreeTextAnalyzer();
        SimpleAnalyzer simple = new SimpleAnalyzer();
        Token[] expected = new Token[]{new Token("foobar", 0, 6)};
        String input = "FooBar";
        this.assertAnalysis((Analyzer)simple, expected, input);
        this.assertAnalysis((Analyzer)mine, expected, input);
        expected = new Token[]{new Token("foo", 0, 3), new Token("bar", 5, 8)};
        input = "Foo, Bar";
        this.assertAnalysis((Analyzer)simple, expected, input);
        this.assertAnalysis((Analyzer)mine, expected, input);
    }

    @Test
    public void testAnalyzer() throws IOException {
        FreeTextAnalyzer analyzer = new FreeTextAnalyzer();
        this.assertAnalysis((Analyzer)analyzer, new Token[]{new Token("foobar", 0, 6)}, "FooBar");
        this.assertAnalysis((Analyzer)analyzer, new Token[]{new Token("foo", 0, 3), new Token("-", 3, 4), new Token("bar", 4, 7)}, "Foo-Bar");
        this.assertAnalysis((Analyzer)analyzer, new Token[]{new Token("cru", 0, 3), new Token("-", 3, 4), new Token("123", 4, 7)}, "CRU-123");
        this.assertAnalysis((Analyzer)analyzer, new Token[]{new Token("the", 0, 3), new Token("foo", 4, 7), new Token("it", 9, 11), new Token("is", 12, 14), new Token("a", 15, 16), new Token("bar", 17, 20), new Token("-", 20, 21), new Token("ing", 21, 24), new Token("my", 25, 27), new Token("whats", 29, 34), new Token("-", 34, 35), new Token("it", 35, 37)}, "The foo, it is a bar-ing my 'whats-it'");
        this.assertAnalysis((Analyzer)analyzer, new Token[]{new Token("-", 0, 1), new Token("this", 2, 6), new Token("line", 7, 11), new Token("is", 12, 14), new Token("funny", 15, 20)}, "- this line is funny");
        this.assertAnalysis((Analyzer)analyzer, new Token[]{new Token("i", 0, 1), new Token("++", 1, 3), new Token("i", 4, 5), new Token("++", 5, 7), new Token("i", 9, 10), new Token("++", 11, 13)}, "i++ i++, i ++");
    }

    @Test
    public void testSearching() throws Exception {
        this.assertSearchMatch("the quick brown", "the", true);
        this.assertSearchMatch("the quick brown", "quick", true);
        this.assertSearchMatch("the quick brown", "th", false);
        this.assertSearchMatch("i++", "i", true);
        this.assertSearchMatch("i++", "i++", true);
        this.assertSearchMatch("i++", "i ++", true);
        this.assertSearchMatch("i", "i++", false);
        String forExpr = "for (int i = 0; i < 10; i++) {";
        this.assertSearchMatch("for (int i = 0; i < 10; i++) {", "i++", true);
        this.assertSearchMatch("for (int i = 0; i < 10; i++) {", "for (int i =", true);
        this.assertSearchMatch("for (int i = 0; i < 10; i++) {", "for (int j =", false);
        this.assertSearchMatch("for (int i = 0; i < 10; i++) {", "10;i++){", true);
        this.assertSearchMatch("for (int i = 0; i < 10; i++) {", "< 10;i++){", true);
        this.assertSearchMatch("http://madbean.com/blog/", "blog", true);
        this.assertSearchMatch("http://madbean.com/blog/", "http://madbean.com/blog/", true);
        this.assertSearchMatch("http://madbean.com/blog/", "madbean.com/blog", true);
        this.assertSearchMatch("http://madbean.com/blog/", "madbean . com", true);
        this.assertSearchMatch("the lazy dog.", "dog.", true);
        this.assertSearchMatch("the lazy dog.", "dog", true);
        this.assertSearchMatch("CRU-123", "CRU-123", true);
        this.assertSearchMatch("CRU-123", "CRU", true);
        this.assertSearchMatch("CRU-123", "cru", true);
        this.assertSearchMatch("CRU-123", "123", true);
        this.assertSearchMatch("10.34", "10.34", true);
        this.assertSearchMatch("10.34", "10", true);
        this.assertSearchMatch("10.34", "10.", true);
        this.assertSearchMatch("10.34", ".34", true);
        this.assertSearchMatch("@Test(123)", "@Test", true);
        this.assertSearchMatch("@Test(123)", "Test", true);
        this.assertSearchMatch("@Test(123)", "@", true);
        this.assertSearchMatch("@Test(123)", "123", true);
        this.assertSearchMatch("@Test(123)", "(", false);
    }

    @Test
    public void testCRU421() throws Exception {
        String input = "<project name=\"apache-ant\" default=\"main\" basedir=\".\">\nfoo content\n&lt;\n</project>\n";
        this.assertSearchMatch(input, "<project", true);
        this.assertSearchMatch(input, "name=\"apache-ant\"", true);
        this.assertSearchMatch(input, "apache-ant", true);
        this.assertSearchMatch(input, "</project>", true);
        this.assertSearchMatch(input, "<project name=\"apache-ant\"", true);
        this.assertSearchMatch(input, "<project name=", true);
        this.assertSearchMatch(input, "<project name= apache-ant", true);
        this.assertSearchMatch(input, "<project name=\"", true);
        this.assertSearchMatch(input, "<project name", true);
        this.assertSearchMatch(input, "foo", true);
        this.assertSearchMatch(input, "content", true);
        this.assertSearchMatch(input, "foo content", true);
        this.assertSearchMatch(input, "foo bar content", false);
        this.assertSearchMatch(input, "&lt;", true);
        this.assertSearchMatch(this.openCRU421TestFile(), "<project", true);
        this.assertSearchMatch(this.openCRU421TestFile(), "</target>", true);
        this.assertSearchMatch(this.openCRU421TestFile(), "</junit>", true);
        this.assertSearchMatch(this.openCRU421TestFile(), "</project>", true);
    }

    private Reader openCRU421TestFile() throws FileNotFoundException {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU421/build.xml");
        return new BufferedReader(new FileReader(f));
    }

    @Test
    public void testCRU449() throws Exception {
        this.assertSearchMatch(this.openCRU449TestFile(), "<database-map", true);
        this.assertSearchMatch(this.openCRU449TestFile(), "CREDIT_MEMO_LINE", true);
        this.assertSearchMatch(this.openCRU449TestFile(), "STATE_TAX_RATE", true);
        this.assertSearchMatch(this.openCRU449TestFile(), "CPR_PRC_ADJ_DOLL", true);
        this.assertSearchMatch(this.openCRU449TestFile(), "PURCH_CROSSDOCK_IND", true);
    }

    private Reader openCRU449TestFile() throws FileNotFoundException {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU449/database-map.xml");
        return new BufferedReader(new FileReader(f));
    }

    private void assertSearchMatch(Reader input, String queryString, boolean expectedFound) throws IOException {
        LuceneTestUtils.assertSearchMatch((Analyzer)new FreeTextAnalyzer(), (LuceneTestUtils.QueryProvider)new OurQueryProvider(), input, queryString, expectedFound);
    }

    private void assertSearchMatch(String input, String queryString, boolean expectedFound) throws IOException {
        LuceneTestUtils.assertSearchMatch((Analyzer)new FreeTextAnalyzer(), (LuceneTestUtils.QueryProvider)new OurQueryProvider(), input, queryString, expectedFound);
    }

    private void assertAnalysis(Analyzer analyzer, Token[] expectedTokens, String input) throws IOException {
        TokenStream ts = analyzer.tokenStream("any", (Reader)new StringReader(input));
        TermAttribute found = (TermAttribute)ts.addAttribute(TermAttribute.class);
        OffsetAttribute offset = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        for (int i = 0; i < expectedTokens.length; ++i) {
            Token expected = expectedTokens[i];
            ts.incrementToken();
            Assert.assertNotNull((String)("reached end-of-stream at token " + i), (Object)found.term());
            String msg = "at " + i + "th token";
            Assert.assertEquals((String)msg, (String)expected.term(), (String)found.term());
            Assert.assertEquals((String)msg, (int)expected.startOffset(), (int)offset.startOffset());
            Assert.assertEquals((String)msg, (int)expected.endOffset(), (int)offset.endOffset());
        }
        Assert.assertFalse((String)("expected end-of-stream but found " + found), (boolean)ts.incrementToken());
    }

    private static class OurQueryProvider
    implements LuceneTestUtils.QueryProvider {
        private OurQueryProvider() {
        }

        @Override
        public Query get(Analyzer analyzer, String field, String query) {
            return LuceneUtils.parsePhrase((String)query, (String)field, (Analyzer)analyzer);
        }
    }
}

