/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.CharAnalyzer;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.junit.Assert;
import org.junit.Test;

public class CharAnalyzerTest {
    @Test
    public void testTokenStream() throws Exception {
        CharAnalyzer analyser = new CharAnalyzer();
        String input = "Text A";
        TokenStream tokenStream = analyser.tokenStream("any", (Reader)new StringReader(input));
        TermAttribute term = (TermAttribute)tokenStream.getAttribute(TermAttribute.class);
        OffsetAttribute offset = (OffsetAttribute)tokenStream.getAttribute(OffsetAttribute.class);
        PositionIncrementAttribute increment = (PositionIncrementAttribute)tokenStream.getAttribute(PositionIncrementAttribute.class);
        tokenStream.incrementToken();
        this.assertNextToken(term, "t", offset, 0, 1, increment, 1);
        tokenStream.incrementToken();
        this.assertNextToken(term, "e", offset, 1, 2, increment, 1);
        tokenStream.incrementToken();
        this.assertNextToken(term, "x", offset, 2, 3, increment, 1);
        tokenStream.incrementToken();
        this.assertNextToken(term, "t", offset, 3, 4, increment, 1);
        tokenStream.incrementToken();
        this.assertNextToken(term, " ", offset, 4, 5, increment, 1);
        tokenStream.incrementToken();
        this.assertNextToken(term, "a", offset, 5, 6, increment, 1);
        tokenStream.close();
    }

    private void assertNextToken(TermAttribute term, String text, OffsetAttribute offset, int start, int end, PositionIncrementAttribute increment, int incrementValue) {
        Assert.assertEquals((Object)text, (Object)term.term());
        Assert.assertEquals((String)("invalid start offset for " + text), (long)start, (long)offset.startOffset());
        Assert.assertEquals((String)("invalid end offset for " + text), (long)end, (long)offset.endOffset());
        Assert.assertEquals((long)incrementValue, (long)increment.getPositionIncrement());
    }
}

