/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.atlassian.fecru.search.index.service.NonScoringCollector;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.Branch;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.junit.Assert;

public class BranchIndexingChecker {
    public static void verifyIndexedBranchesWithRevCache(InternalRevisionCache<?> cache) {
        ImmutableSet revcacheBranches = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)cache.getBranches(), (Function)Branch.TO_NAME));
        Set xrepBranches = (Set)cache.getCrossRepLuceneConnection().withIndexSearcher((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, indexSearcher -> {
            final HashSet xrepBranches1 = Sets.newHashSet();
            Query allBranches = BranchQueryBuilder.queryByDocType();
            indexSearcher.search(allBranches, (Collector)new NonScoringCollector(){

                public void collect(int doc) throws IOException {
                    BranchDocInfo branch = BranchDocInfo.fromDocumentToBranchDocInfo((Document)this.currentReader.document(doc));
                    xrepBranches1.add(branch.getBranch());
                }
            });
            return xrepBranches1;
        });
        Assert.assertEquals((Object)revcacheBranches, (Object)xrepBranches);
    }
}

