/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.logging;

import com.cenqua.fisheye.logging.CategoryNDCFilter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransaction;
import org.hibernate.event.internal.AbstractFlushingEventListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CategoryNDCFilterTest {
    private CategoryNDCFilter filter;

    @Before
    public void setUp() throws Exception {
        this.filter = new CategoryNDCFilter();
    }

    @Test
    public void testDecide() throws Exception {
        this.filter.setCategories("com.category,com.category2");
        this.filter.setNdcPrefix("muteMe");
        Assert.assertThat((String)"no NDC, different category - no decision expected", (Object)this.filter.decide(this.makeLoggingEvent("another.category", null)), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"no NDC, matching category - no decision expected", (Object)this.filter.decide(this.makeLoggingEvent("com.category", null)), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"no NDC, matching category2 - no decision expected", (Object)this.filter.decide(this.makeLoggingEvent("com.category2", null)), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"different NDC, different category - no decision expected", (Object)this.filter.decide(this.makeLoggingEvent("another.category", "some other NDC")), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"different NDC, matching category - no decision expected", (Object)this.filter.decide(this.makeLoggingEvent("com.category", "some other NDC")), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"different NDC, matching category2 - no decision expected", (Object)this.filter.decide(this.makeLoggingEvent("com.category2", "some other NDC")), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"matching NDC, different category - no decision expected", (Object)this.filter.decide(this.makeLoggingEvent("another.category", "muteMePlease")), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"matching NDC, matching category - DENY decision expected", (Object)this.filter.decide(this.makeLoggingEvent("com.category", "muteMePlease")), (Matcher)Matchers.equalTo((Object)-1));
        Assert.assertThat((String)"matching NDC, matching category2 - DENY decision expected", (Object)this.filter.decide(this.makeLoggingEvent("com.category2", "muteMePlease")), (Matcher)Matchers.equalTo((Object)-1));
    }

    @Test
    public void testDecideNoNDC() throws Exception {
        this.testMessageFiltering("Expected error message to be logged with no NDC", (Matcher<Object>)Matchers.notNullValue(), null, new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.event.internal.AbstractFlushingEventListener").error((Object)"test");
            }
        });
        this.testMessageFiltering("Expected error message to be logged with no NDC", (Matcher<Object>)Matchers.notNullValue(), null, new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.engine.jdbc.spi.SqlExceptionHelper").warn((Object)"SQL Error: 0, SQLState: null");
            }
        });
        this.testMessageFiltering("Expected error message to be logged with no NDC", (Matcher<Object>)Matchers.notNullValue(), null, new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.engine.jdbc.spi.SqlExceptionHelper").error((Object)"failed batch");
            }
        });
    }

    @Test
    public void testDecideOtherNDC() throws Exception {
        this.testMessageFiltering("Expected error message to be logged when NDC doesn't match", (Matcher<Object>)Matchers.notNullValue(), "some other context", new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.event.internal.AbstractFlushingEventListener").error((Object)"test");
            }
        });
        this.testMessageFiltering("Expected error message to be logged when NDC doesn't match", (Matcher<Object>)Matchers.notNullValue(), "some other context", new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.engine.jdbc.spi.SqlExceptionHelper").warn((Object)"SQL Error: 0, SQLState: null");
            }
        });
        this.testMessageFiltering("Expected error message to be logged when NDC doesn't match", (Matcher<Object>)Matchers.notNullValue(), "some other context", new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.engine.jdbc.spi.SqlExceptionHelper").error((Object)"failed batch");
            }
        });
    }

    @Test
    public void testDecideRightNDC() throws Exception {
        this.testMessageFiltering("Expected error messages to be filtered out when NDC matches", (Matcher<Object>)Matchers.nullValue(), "muteMe please", new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.event.internal.AbstractFlushingEventListener").error((Object)"test");
            }
        });
        this.testMessageFiltering("Expected error messages to be filtered out when NDC matches", (Matcher<Object>)Matchers.nullValue(), "muteMe please", new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.engine.jdbc.spi.SqlExceptionHelper").warn((Object)"SQL Error: 0, SQLState: null");
            }
        });
        this.testMessageFiltering("Expected error messages to be filtered out when NDC matches", (Matcher<Object>)Matchers.nullValue(), "muteMe please", new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.engine.jdbc.spi.SqlExceptionHelper").error((Object)"failed batch");
            }
        });
    }

    @Test
    public void testDecideRightNDCButOtherError() throws Exception {
        this.testMessageFiltering("Expected other error messages to be still reported even with correct MDC", (Matcher<Object>)Matchers.notNullValue(), "muteMe please", new Runnable(){

            @Override
            public void run() {
                Logger.getLogger((String)"org.hibernate.engine.transaction.internal.jdbc.JdbcTransaction").error((Object)"JDBC commit failed");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageFiltering(String message, Matcher<Object> messageMatcher, String ndc, Runnable body) {
        this.filter.setCategories("org.hibernate.event.internal.AbstractFlushingEventListener, org.hibernate.engine.jdbc.spi.SqlExceptionHelper");
        this.filter.setNdcPrefix("muteMe");
        TestAppender testAppender = new TestAppender();
        testAppender.addFilter((Filter)this.filter);
        Class[] loggerClassesArray = new Class[]{AbstractFlushingEventListener.class, SqlExceptionHelper.class, JdbcTransaction.class};
        List<Class> loggerClasses = Arrays.asList(loggerClassesArray);
        List loggers = Lists.transform(loggerClasses, Logger::getLogger);
        ImmutableMap levels = Maps.uniqueIndex((Iterable)loggers, logger -> {
            logger.addAppender((Appender)testAppender);
            AtomicReference<Level> orgLevel = new AtomicReference<Level>(logger.getLevel());
            logger.setLevel(Level.ALL);
            return orgLevel;
        });
        try {
            testAppender.resetLastEvent();
            if (null != ndc) {
                NDC.push((String)ndc);
            }
            try {
                body.run();
                Assert.assertThat((String)message, (Object)testAppender.getLastEvent(), messageMatcher);
            }
            finally {
                if (null != ndc) {
                    NDC.pop();
                }
            }
        }
        finally {
            for (Map.Entry entry : levels.entrySet()) {
                ((Logger)entry.getValue()).removeAppender((Appender)testAppender);
                ((Logger)entry.getValue()).setLevel((Level)((AtomicReference)entry.getKey()).get());
            }
        }
    }

    private LoggingEvent makeLoggingEvent(String category, String ndc) {
        return new LoggingEvent(null, (Category)Logger.getLogger((String)category), 0L, Level.DEBUG, (Object)"message", Thread.currentThread().getName(), null, ndc, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetCategoriesNull() {
        this.filter.setCategories(null);
        Assert.fail((String)"Filter should not accept null or empty category name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetCategoriesNullSet() {
        this.filter.setCategoriesSet(null);
        Assert.fail((String)"Filter should not accept null or empty category name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetCategoriesEmpty() {
        this.filter.setCategories("");
        Assert.fail((String)"Filter should not accept null or empty category name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetCategoriesEmptySet() {
        this.filter.setCategoriesSet(new HashSet());
        Assert.fail((String)"Filter should not accept null or empty category name");
    }

    @Test
    public void testSetCategoriesWhiteCharactersStripped() {
        this.filter.setCategories(" cat1 , cat2 ,\t cat3,cat4,cat5 ");
        HashSet cats = Sets.newHashSet((Iterable)this.filter.getCategoriesSet());
        Assert.assertThat((String)"all elements found", (Object)cats.size(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((String)"trimmed category names", (Object)cats, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Sets.newHashSet((Object[])new String[]{"cat1", "cat2", "cat3", "cat4", "cat5"}))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNdcPrefixNull() {
        this.filter.setNdcPrefix(null);
        Assert.fail((String)"Filter should not accept null or empty NDC prefix");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNdcPrefixEmpty() {
        this.filter.setNdcPrefix("");
        Assert.fail((String)"Filter should not accept null or empty NDC prefix");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testActivateOptionsMissingProps() throws Exception {
        this.filter.activateOptions();
        Assert.fail((String)"Filter should fail if activated with missing properties");
    }

    private static class TestAppender
    extends AppenderSkeleton {
        private LoggingEvent lastEvent;

        private TestAppender() {
        }

        protected void append(LoggingEvent event) {
            this.lastEvent = event;
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        void resetLastEvent() {
            this.lastEvent = null;
        }

        LoggingEvent getLastEvent() {
            return this.lastEvent;
        }
    }
}

