/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license.util;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.DateEditor;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.common.util.ProductLicenseProperties;
import com.atlassian.extras.core.crucible.CrucibleProductLicenseFactory;
import com.atlassian.extras.core.fisheye.FisheyeProductLicenseFactory;
import com.cenqua.fisheye.util.Interval;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class LicenseTestUtils {
    private static FisheyeProductLicenseFactory feLicenseFactory = new FisheyeProductLicenseFactory();
    private static CrucibleProductLicenseFactory cruLicenseFactory = new CrucibleProductLicenseFactory();

    public static ProductLicense make(long now, String issuedAgo, String exp, String term, String maintPeriod) throws Exception {
        return LicenseTestUtils.makeWithProps(now, issuedAgo, exp, term, maintPeriod, new Properties());
    }

    public static ProductLicense makeWithProps(long now, String issuedAgo, String exp, String term, String maintPeriod, Properties additionalProps) throws Exception {
        long issued = now - LicenseTestUtils.toMillis(issuedAgo);
        long expiration = exp == null ? 0L : issued + LicenseTestUtils.toMillis(exp);
        long termination = term == null ? 0L : issued + LicenseTestUtils.toMillis(term);
        long maintExp = maintPeriod == null ? 0L : issued + LicenseTestUtils.toMillis(maintPeriod);
        Properties props = new Properties();
        props.put("licenseVersion", "1");
        props.put("Description", "FishEye Commercial License");
        props.put("Evaluation", "true");
        props.put("Subscription", "false");
        props.put("ServerID", "ABCD-EFGH");
        props.put("Organisation", "Test Inc");
        props.put("ContactEMail", "test@example.com");
        props.put("ContactName", "Mr Test Tester");
        props.put("CreationDate", DateEditor.getString((Date)new Date(issued)));
        if (expiration != 0L) {
            props.put("LicenseExpiryDate", DateEditor.getString((Date)new Date(expiration)));
            if (termination != 0L) {
                props.put("GracePeriod", Long.toString((termination - expiration) / 86400000L));
            }
        }
        if (maintExp != 0L) {
            props.put("MaintenanceExpiryDate", DateEditor.getString((Date)new Date(maintExp)));
        }
        props.put("SEN", "Car 54");
        props.put("NumberOfUsers", "-1");
        props.put("LicenseTypeName", "COMMERCIAL");
        props.putAll((Map<?, ?>)additionalProps);
        return feLicenseFactory.getLicense(Product.FISHEYE, (LicenseProperties)new ProductLicenseProperties(Product.FISHEYE, props));
    }

    private static long toMillis(String ago) {
        return new Interval(ago).getValueInMillis();
    }
}

