/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseInfo;
import junit.framework.TestCase;

public class StarterLicenseTest
extends TestCase {
    public void testStarter() {
        LicenseHolder holder = LicenseHolder.makeFishEyeOnlyLicense((String)"AAABMQ0ODAoPeNpdkFFLwzAUhd/zKwK+KOhowwZaCChrhMHspK0++XKtdzbQpiFJx/rvTW07ayEvy\nbk537nnKi9bmqGmbE3DIGIsYiEVWU5ZEDyQGG1hpHayUfxZ2lJ0SK/DgBZNXUvn0Fiq0VCDurHSN\naa7pZu/m0R78xHRzIHxo3QvC1QWSdLWn2gOxzfr//MwIFuD0CNicMh77p0/bE22jXJQuARq5JOJO\nEOtK5w08QKy4nYQH3EQVz4eESeo2l9bfoTKY48+P3a4mvDbyw59hkn1nvKE3JkWSTUEfvcjvQ0jH\nqYcKlAFirOWphsTh8GYeMlIZ1XwDTmYb1DSwr8+l/VkIuH3oS9/fNjFfL+L5y8zdqsq6bfArwt6n\nMk7jUNx+VOai5S8tqYoweKy5B/6o7FHMC0CFQCFOtZh47HhjSXWexBOhZJ+ZPgOFAIUGkrapw088\n2xL1hJux1fDHJ2LMXw=X02fb");
        StarterLicenseTest.assertFalse((String)"Should not be an eval", (boolean)holder.getFishEyeLicense().isEvaluation());
        StarterLicenseTest.assertFalse((boolean)holder.hasCrucible());
        LicenseInfo info = new LicenseInfo(holder);
        StarterLicenseTest.assertNotNull((Object)holder.getFishEyeLicense().getProperty("fisheye.NumberOfCommitters"));
        StarterLicenseTest.assertNotNull((Object)holder.getFishEyeLicense().getProperty("fisheye.NumberOfRepositories"));
        StarterLicenseTest.assertEquals((int)5, (int)info.getMaxRepositories());
        StarterLicenseTest.assertEquals((int)10, (int)info.getMaxCommitters());
    }

    public void testNonStarter() {
        LicenseHolder holder = LicenseHolder.makeFishEyeOnlyLicense((String)"NrnOTfExuubdKcdmeIUaajJQnRRXTHOtuokTtUwllXnfds\nmi2KL5Bz38iGn2KYqBWzR7Xu2KI1VwXToiNEzkm1h7ZsLI\nOMoOsxQoqQrqqOroRNquTpNPnnpNMOqonOtxXvttUTvwtu\nwqqnonmUUnnoromrommmmmUUnnoromrommmmmUU1qiXppf\nXkUUnm");
        StarterLicenseTest.assertFalse((boolean)holder.hasCrucible());
        LicenseInfo info = new LicenseInfo(holder);
        StarterLicenseTest.assertNull((Object)holder.getFishEyeLicense().getProperty("fisheye.NumberOfCommitters"));
        StarterLicenseTest.assertNull((Object)holder.getFishEyeLicense().getProperty("fisheye.NumberOfRepositories"));
        StarterLicenseTest.assertEquals((int)-1, (int)info.getMaxRepositories());
        StarterLicenseTest.assertEquals((int)-1, (int)info.getMaxCommitters());
    }
}

