/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.license.LicenseException;
import com.cenqua.fisheye.license.LicenseHolder;
import junit.framework.TestCase;

public class NgLicenseTest
extends TestCase {
    private static final String NG_LICENSE = "AAACqg0ODAoPeNqNVmFvokAQ/e6v6B+osTS99i6huVZpY1FQhLR3MWlwHete3QV3Aeu/P8QlZYEF/\nGIYlzfz3ryZFQV0059gBJSDewxBH6aBXQwUwfLXxQPy10Aw6iEWY4RXO+jPYoa2PoeRH4GuDQY/L\ngdXl9pNb+WTVRBIUI9ZqAgjHzK+QsyOOdCtAPpONfUxjYD6aS31RxfAEmDjkX6tXfXQLkgf+lZMV\nsDsjceBcT3DCw7rPGV69kq7FrEhAz/CAS1T+YeZX3qhgrrBfAtH6KdyRT6KLJ+Abghcm334FPMMW\n3eBR71qJMtRDQsSZdRckTKLWAqf+yeCqezDgBBgCPu7c7pWPVWCoJNJWt/OcjRCdOy7zD5Xuq7Zc\nuzc1JqGtJae5ygK+ZTGjGNJRymHkeLudPhN0q8+CsiZpKLXFQcpQbIULWPWaF0VcomlcJEqk5C4u\nWcnwqpaRKkKPTp6QepwTiAlhxPQIxbDuYQ6b9QMV3ETNBuh0caVVmaEVDqWZlYMeLNmtaw7Fa5iX\nZqU0kKpxxTFVDdq1vUWk7XOXIaiNN/3MmhWSlWG+Lkdv04wsVaLNhN43ViVdpC002vmPS+lInSX7\nsj2aq/vXEw3HnWXZttNqDRE/dTYk9H7ZDw0rIXx/mQ7U31mWfYidvGKuI+f4as5cUcva7zeTpn38\nfk8ibznjfuGTPMlYdsnvKQEayaa4aMHdnJ7lxg3w9Efur33NPPG+KlN7jxzzP6+jkP3az0bPy9p4\nEzf4r2zd0KHBMSxmRPxqW1b+7lNLbafzxeLQxwdAp54HqVLGsaURJycPqeA9Giuwv2SVm+uigbFt\nVy61rqt37wFxfUz3MU8AmYFa+D6oCfDy+MhglkZdbtSVURxU2eX4svYebgwUuuwkGEu/UX8D8e/f\n0EwLQIUSfhmRdBN2lPwaFM3zj3ERC9uqGUCFQCFxbrPGZlsZ0ymJHgHi3MGc6VUEQ==X0110j";
    private static final String TERMINATED_NG_LICENSE = "AAABGg0ODAoPeNqVUstqwzAQvPsr+gMxtpP2UBAUHBUKaVJoeutFEZtGYMthJZn676saVX6oqulJM\nJrZndldjkZwcaog3Zv6BHg4vylARYrb5CzUBTpId4KDVHDsrkAeLUY7eL+/oS2rDNOikUmgLBupG\ndd7VgOhvk6J0PO3TAMpsuxuleWrUR+nos9MVAQeavukvKn9/ytgC/i0Jesi9+CLQX5hCuZFY7gLQ\nz+vArvR5+b7k/thxOQxj4MylnLifqA7PxbPi/V85EsuI3OeoJY96dSvsXTgdI8/BWw4qUEyySMOZ\njad+SDU3+LgahbbDg3+QV26qgN+MClUPwFyBKWTWKqQGSKx7fstWCuiBaLRwKj0r6c9pn4Bl3E/X\njAtAhR4AzeuV3BPcKSpZyz1yLUJhTT6AAIVAIhIaKUbPes4HSU1BDk7OFTNkI/9X01ea";

    public void testCommercialLicenses() throws LicenseException {
        LicenseHolder holder = LicenseHolder.makeFishEyeCrucibleLicense((String)NG_LICENSE, (String)NG_LICENSE);
        NgLicenseTest.assertTrue((boolean)holder.hasFishEye());
        NgLicenseTest.assertTrue((boolean)holder.canDecodeFishEye());
        NgLicenseTest.assertTrue((boolean)holder.isFishEyeGracePeriodExpired());
        NgLicenseTest.assertFalse((boolean)holder.isFishEyeValidForCurrentBuild());
        NgLicenseTest.assertTrue((boolean)holder.hasCrucible());
        NgLicenseTest.assertTrue((boolean)holder.canDecodeCrucible());
        NgLicenseTest.assertTrue((boolean)holder.isCrucibleGracePeriodExpired());
        NgLicenseTest.assertFalse((boolean)holder.isCrucibleValidForCurrentBuild());
    }

    public void testTerminatedEvaluationLicense() {
        LicenseHolder holder = LicenseHolder.makeCrucibleOnlyLicense((String)TERMINATED_NG_LICENSE);
        NgLicenseTest.assertTrue((boolean)holder.hasCrucible());
        NgLicenseTest.assertTrue((boolean)holder.canDecodeCrucible());
        NgLicenseTest.assertTrue((boolean)holder.isCrucibleGracePeriodExpired());
        NgLicenseTest.assertFalse((boolean)holder.isCrucibleValidForCurrentBuild());
        NgLicenseTest.assertFalse((boolean)holder.hasFishEye());
        NgLicenseTest.assertTrue((boolean)holder.isCrucibleOnly());
        NgLicenseTest.assertTrue((boolean)holder.canDecodeFishEye());
        NgLicenseTest.assertTrue((boolean)holder.isFishEyeGracePeriodExpired());
        NgLicenseTest.assertFalse((boolean)holder.isFishEyeValidForCurrentBuild());
    }
}

