/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.extras.common.LicenseException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.license.LicenseLoader;
import java.io.IOException;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class LicenseLoaderTest
extends TestCase {
    private static final TimeZone THE_TIMEZONE = TimeZone.getTimeZone("GMT+10");

    public void testValidate() throws LicenseException {
        final AtomicBoolean hasFishEye = new AtomicBoolean(false);
        final AtomicBoolean canDecodeFishEye = new AtomicBoolean(false);
        final AtomicBoolean isFishEyeTerminated = new AtomicBoolean(true);
        final AtomicBoolean isFishEyeValidForCurrentBuild = new AtomicBoolean(false);
        final AtomicBoolean hasCrucible = new AtomicBoolean(false);
        final AtomicBoolean canDecodeCrucible = new AtomicBoolean(false);
        final AtomicBoolean isCrucibleTerminated = new AtomicBoolean(true);
        final AtomicBoolean isCrucibleValidForCurrentBuild = new AtomicBoolean(false);
        LicenseHolder lh = new LicenseHolder("oQRoXxFbidCOIPBMcvpWPonqOopfOseDkxJumwRSCGHnXDF\nmj2KnaI4pzCWZx7fvqSnaz3>2L05UMjv<mn>CrCy0VMvOj2\nRqRnxWnrMOPQroQOmMqxVRrRooPPOPmQoQtstwSTtXxTTtv\nprQnopmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXppfX\nkUUnmm", "nOnmmHxExnLDwaOGsEhRGCgjpnxUoUIMGjmqVgVwFvugdh\nmi2K<TZmRgd2lEYIupqfwaOr2KVGyH>C3PXkNYyQM8TXR6\nNmOMUVnNoNPPrnmOQoPutNOpONMrQoPpNRWWTWWtWUvwsv\numRPnnpmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXpp\nfXkUUnmm"){

            public boolean canDecodeCrucible() {
                return canDecodeCrucible.get();
            }

            public boolean canDecodeFishEye() {
                return canDecodeFishEye.get();
            }

            public boolean hasCrucible() {
                return hasCrucible.get();
            }

            public boolean hasFishEye() {
                return hasFishEye.get();
            }

            public boolean isCrucibleGracePeriodExpired() {
                return isCrucibleTerminated.get();
            }

            public boolean isCrucibleValidForCurrentBuild() {
                return isCrucibleValidForCurrentBuild.get();
            }

            public boolean isFishEyeGracePeriodExpired() {
                return isFishEyeTerminated.get();
            }

            public boolean isFishEyeValidForCurrentBuild() {
                return isFishEyeValidForCurrentBuild.get();
            }
        };
        LicenseLoader l = new LicenseLoader(null);
        this.expectLicenseException(l, lh, "Could not find a FishEye or Crucible license.");
        hasFishEye.set(true);
        this.expectLicenseException(l, lh, "Your FishEye license is invalid.");
        canDecodeFishEye.set(true);
        this.expectLicenseException(l, lh, "Your FishEye license terminated on");
        isFishEyeTerminated.set(false);
        this.expectLicenseException(l, lh, "Upgrades for your FishEye license ended");
        isFishEyeValidForCurrentBuild.set(true);
        l.validate(lh);
        hasCrucible.set(true);
        this.expectLicenseException(l, lh, "Your Crucible license is invalid.");
        canDecodeCrucible.set(true);
        this.expectLicenseException(l, lh, "Your Crucible license terminated on");
        isCrucibleTerminated.set(false);
        this.expectLicenseException(l, lh, "Upgrades for your Crucible license ended");
        isCrucibleValidForCurrentBuild.set(true);
        l.validate(lh);
    }

    private void expectLicenseException(LicenseLoader loader, LicenseHolder holder, String msg) {
        try {
            loader.validate(holder);
        }
        catch (LicenseException e) {
            LicenseLoaderTest.assertTrue((String)("Exception message '" + e.getMessage() + "' didn't contain '" + msg + "'"), (boolean)e.getMessage().contains(msg));
            return;
        }
        LicenseLoaderTest.fail((String)"Expected LicenseException to be thrown!");
    }

    public void testBothXmlLicensesSpecified() throws Exception {
        LicenseLoader loader = this.createLoader("AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj", "AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
        LicenseInfo licenseInfo = loader.loadAndValidate();
        LicenseLoaderTest.assertEquals((String)"FishEye, Crucible", (String)licenseInfo.getProductName());
        LicenseLoaderTest.assertEquals((String)"FishEye: Commercial", (String)licenseInfo.getFisheyeLicense().getDescription());
        LicenseLoaderTest.assertEquals((String)"Crucible: Commercial", (String)licenseInfo.getCrucibleLicense().getDescription());
        LicenseLoaderTest.assertTrue((boolean)licenseInfo.isCrucible());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isCrucibleOnly());
        LicenseLoaderTest.assertTrue((boolean)licenseInfo.isFishEye());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isFishEyeOnly());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isAllProductsInEval());
    }

    public void testOnlyFisheyeLicense() throws Exception {
        LicenseLoader loader = this.createLoader("AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj", null);
        LicenseInfo licenseInfo = loader.loadAndValidate();
        LicenseLoaderTest.assertEquals((String)"FishEye", (String)licenseInfo.getProductName());
        LicenseLoaderTest.assertEquals((String)"FishEye: Commercial", (String)licenseInfo.getFisheyeLicense().getDescription());
        LicenseLoaderTest.assertNull((String)("Crucible license is set when only a Fisheye license was specified. Crucible license: " + licenseInfo.getCrucibleLicense()), (Object)licenseInfo.getCrucibleLicense());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isCrucible());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isCrucibleOnly());
        LicenseLoaderTest.assertTrue((boolean)licenseInfo.isFishEye());
        LicenseLoaderTest.assertTrue((boolean)licenseInfo.isFishEyeOnly());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isAllProductsInEval());
    }

    public void testOnlyCrucibleLicense() throws Exception {
        LicenseLoader loader = this.createLoader(null, "AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
        LicenseInfo licenseInfo = loader.loadAndValidate();
        LicenseLoaderTest.assertEquals((String)"Crucible", (String)licenseInfo.getProductName());
        LicenseLoaderTest.assertEquals((String)"Crucible: Commercial", (String)licenseInfo.getCrucibleLicense().getDescription());
        LicenseLoaderTest.assertTrue((boolean)licenseInfo.isCrucible());
        LicenseLoaderTest.assertTrue((boolean)licenseInfo.isCrucibleOnly());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isFishEye());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isFishEyeOnly());
        LicenseLoaderTest.assertFalse((boolean)licenseInfo.isAllProductsInEval());
    }

    private LicenseLoader createLoader(String feXmlLicense, String cruXmlLicense) throws IOException {
        return this.createLoader(this.makeMockConfig(feXmlLicense, cruXmlLicense));
    }

    private LicenseLoader createLoader(ConfigDocument.Config config) throws IOException {
        return new LicenseLoader(config);
    }

    private ConfigDocument.Config makeMockConfig(String fisheyeLicense, String crucibleLicense) {
        ConfigDocument d = ConfigDocument.Factory.newInstance();
        ConfigDocument.Config config = d.addNewConfig();
        LicenseType l = config.addNewLicense();
        if (fisheyeLicense != null) {
            l.setFisheye(fisheyeLicense);
        }
        if (crucibleLicense != null) {
            l.setCrucible(crucibleLicense);
        }
        return config;
    }
}

