/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseUtils;
import junit.framework.TestCase;

public class LicenseHolderTest
extends TestCase {
    public void testFEMissing() {
        LicenseHolder licenseHolder = LicenseHolder.makeCrucibleOnlyLicense((String)"AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
        LicenseHolderTest.assertFalse((boolean)licenseHolder.hasFishEye());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.isCrucibleOnly());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.hasCrucible());
    }

    public void testCruMissing() {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeOnlyLicense((String)"AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj");
        LicenseHolderTest.assertTrue((boolean)licenseHolder.hasFishEye());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.hasCrucible());
    }

    public void testFEUndecodable() {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeCrucibleLicense((String)"Can't decode this!", (String)"AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
        LicenseHolderTest.assertFalse((boolean)licenseHolder.hasFishEye());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.canDecodeFishEye());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.hasCrucible());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.canDecodeCrucible());
    }

    public void testCruUndecodable() {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeCrucibleLicense((String)"AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj", (String)"Can't decode this either.");
        LicenseHolderTest.assertTrue((boolean)licenseHolder.canDecodeFishEye());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.hasCrucible());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.canDecodeCrucible());
    }

    public void testFETerminated() {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeCrucibleLicense((String)"oQRoXxFbidCOIPBMcvpWPonqOopfOseDkxJumwRSCGHnXDF\nmj2KnaI4pzCWZx7fvqSnaz3>2L05UMjv<mn>CrCy0VMvOj2\nRqRnxWnrMOPQroQOmMqxVRrRooPPOPmQoQtstwSTtXxTTtv\nprQnopmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXppfX\nkUUnmm", (String)"AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
        LicenseHolderTest.assertTrue((boolean)licenseHolder.canDecodeFishEye());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.isFishEyeGracePeriodExpired());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.isCrucibleGracePeriodExpired());
    }

    public void testCruTerminated() {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeCrucibleLicense((String)"AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj", (String)"nOnmmHxExnLDwaOGsEhRGCgjpnxUoUIMGjmqVgVwFvugdh\nmi2K<TZmRgd2lEYIupqfwaOr2KVGyH>C3PXkNYyQM8TXR6\nNmOMUVnNoNPPrnmOQoPutNOpONMrQoPpNRWWTWWtWUvwsv\numRPnnpmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXpp\nfXkUUnmm");
        LicenseHolderTest.assertFalse((boolean)licenseHolder.isFishEyeGracePeriodExpired());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.canDecodeCrucible());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.isCrucibleGracePeriodExpired());
    }

    public void testInvalidLicensesForBuild() {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeCrucibleLicense((String)"NrnOTfExuubdKcdmeIUaajJQnRRXTHOtuokTtUwllXnfds\nmi2KL5Bz38iGn2KYqBWzR7Xu2KI1VwXToiNEzkm1h7ZsLI\nOMoOsxQoqQrqqOroRNquTpNPnnpNMOqonOtxXvttUTvwtu\nwqqnonmUUnnoromrommmmmUUnnoromrommmmmUU1qiXppf\nXkUUnm", (String)"NmqPnTMUNBHMowFUvFArdnAGqppDGgvkcewDBDnaeFeevvC\nmj2KoaWVW7DROi3NA4RDa2Ki2L08>4NaOo8Ac2fizl24vep\nrqRnvVRrrMoRRpMPMOoStPQQNmQOMOPMRRtwTxuttTxvSxV\noMnnnmUUnnoromrommmmmUUnnoromrommmmmUU1qiXppfXk\nUUnm");
        LicenseHolderTest.assertFalse((boolean)licenseHolder.isFishEyeGracePeriodExpired());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.isFishEyeValidForCurrentBuild());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.isCrucibleGracePeriodExpired());
        LicenseHolderTest.assertFalse((boolean)licenseHolder.isCrucibleValidForCurrentBuild());
    }

    public void testFECopiedFromCruEval() {
        LicenseHolder licenseHolder = LicenseHolder.makeCrucibleLicenseWithFishEyeEval((String)"nOnmmHxExnLDwaOGsEhRGCgjpnxUoUIMGjmqVgVwFvugdh\nmi2K<TZmRgd2lEYIupqfwaOr2KVGyH>C3PXkNYyQM8TXR6\nNmOMUVnNoNPPrnmOQoPutNOpONMrQoPpNRWWTWWtWUvwsv\numRPnnpmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXpp\nfXkUUnmm");
        LicenseHolderTest.assertTrue((boolean)licenseHolder.isCrucibleGracePeriodExpired());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.hasFishEye());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.hasCrucible());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.canDecodeFishEye());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.isFishEyeGracePeriodExpired());
    }

    public void testCruCopiedFromFEEval() {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeLicenseWithCrucibleEval((String)"oQRoXxFbidCOIPBMcvpWPonqOopfOseDkxJumwRSCGHnXDF\nmj2KnaI4pzCWZx7fvqSnaz3>2L05UMjv<mn>CrCy0VMvOj2\nRqRnxWnrMOPQroQOmMqxVRrRooPPOPmQoQtstwSTtXxTTtv\nprQnopmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXppfX\nkUUnmm");
        LicenseHolderTest.assertTrue((boolean)licenseHolder.isFishEyeGracePeriodExpired());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.hasFishEye());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.hasCrucible());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.canDecodeFishEye());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.canDecodeCrucible());
        LicenseHolderTest.assertTrue((boolean)licenseHolder.isCrucibleGracePeriodExpired());
    }

    public void testBuildDate() {
        LicenseUtils.getOurBuildDate();
    }
}

