/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.extras.api.ProductLicense;
import com.cenqua.fisheye.license.LicenseUtils;
import com.cenqua.fisheye.license.util.LicenseTestUtils;
import java.util.Properties;
import junit.framework.TestCase;

public class FisheyeLicenseTest
extends TestCase {
    long now = System.currentTimeMillis();

    public void testMaintPeriods() throws Exception {
        ProductLicense l = LicenseTestUtils.make(this.now, "300d", null, null, null);
        FisheyeLicenseTest.assertNull((Object)LicenseUtils.getLatestBuildAllowed((ProductLicense)l));
        this.assertValid(l);
        l = LicenseTestUtils.make(this.now, "300d", null, null, "365d");
        FisheyeLicenseTest.assertTrue((boolean)LicenseUtils.isValidForCurrentBuild((ProductLicense)l));
        this.assertValid(l);
        l = LicenseTestUtils.make(this.now, "367d", null, null, "365d");
        FisheyeLicenseTest.assertTrue((boolean)LicenseUtils.isValidForCurrentBuild((ProductLicense)l));
        this.assertValid(l);
        l = LicenseTestUtils.make(this.now, "13mo", null, null, "365d");
        FisheyeLicenseTest.assertFalse((boolean)LicenseUtils.isValidForCurrentBuild((ProductLicense)l));
        this.assertNotValid(l);
    }

    public void testEnterpriseProps() throws Exception {
        ProductLicense l = LicenseTestUtils.make(this.now, "1y", null, null, null);
        FisheyeLicenseTest.assertTrue((boolean)l.isUnlimitedNumberOfUsers());
        Properties props = new Properties();
        props.put("NumberOfUsers", "10");
        l = LicenseTestUtils.makeWithProps(this.now, "1y", null, null, null, props);
        FisheyeLicenseTest.assertFalse((boolean)l.isUnlimitedNumberOfUsers());
        FisheyeLicenseTest.assertEquals((int)10, (int)l.getMaximumNumberOfUsers());
    }

    private void assertNotValid(ProductLicense l) {
        FisheyeLicenseTest.assertFalse((boolean)LicenseUtils.isValidForCurrentBuild((ProductLicense)l));
    }

    private void assertValid(ProductLicense l) throws Exception {
        FisheyeLicenseTest.assertTrue((boolean)LicenseUtils.isValidForCurrentBuild((ProductLicense)l));
    }
}

