/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.fecru.license.AvailableLicensedUsersExceededMessageSource;
import com.atlassian.fecru.license.LicenseManager;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.web.filters.SystemMessage;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AvailableLicensedUsersExceededMessageSourceTest {
    private LicenseManager licenseManager;

    @Before
    public void setUp() throws Exception {
        this.licenseManager = (LicenseManager)Mockito.mock(LicenseManager.class);
    }

    @Test
    public void testLicenseMessageShownForExceededFishEyeUsers() throws Exception {
        Mockito.when((Object)this.licenseManager.getExcessFEUsers()).thenReturn((Object)1);
        Mockito.when((Object)this.licenseManager.getExcessCruUsers()).thenReturn((Object)0);
        List<SystemMessage> messageList = this.getMessages();
        AvailableLicensedUsersExceededMessageSourceTest.assertMessage(messageList, "You have exceeded the maximum number of users for FishEye.");
    }

    @Test
    public void testLicenseMessageShownForExceededCrucibleEyeUsers() throws Exception {
        Mockito.when((Object)this.licenseManager.getExcessFEUsers()).thenReturn((Object)0);
        Mockito.when((Object)this.licenseManager.getExcessCruUsers()).thenReturn((Object)1);
        List<SystemMessage> messageList = this.getMessages();
        AvailableLicensedUsersExceededMessageSourceTest.assertMessage(messageList, "You have exceeded the maximum number of users for Crucible.");
    }

    @Test
    public void testLicenseMessageIsNotShownWhenLimitsAreNotExceeded() throws Exception {
        Mockito.when((Object)this.licenseManager.getExcessFEUsers()).thenReturn((Object)0);
        Mockito.when((Object)this.licenseManager.getExcessCruUsers()).thenReturn((Object)0);
        List<SystemMessage> messageList = this.getMessages();
        Assert.assertThat(messageList, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private List<SystemMessage> getMessages() throws Exception {
        return new AvailableLicensedUsersExceededMessageSource(this.licenseManager).getMessages(null);
    }

    private static void assertMessage(List<SystemMessage> messageList, String message) {
        Assert.assertEquals((long)1L, (long)messageList.size());
        SystemMessage systemMessage = messageList.get(0);
        Assert.assertThat((Object)systemMessage.getText(), (Matcher)Matchers.is((Object)message));
        Assert.assertThat((Object)systemMessage.getUrl(), (Matcher)Matchers.is((Object)HelpUtil.getFishEyeHelpPath((String)"fisheye.license.exceeded")));
        Assert.assertTrue((boolean)systemMessage.isAdminOnly());
        Assert.assertFalse((boolean)systemMessage.getMessageDismissedProperty().isPresent());
    }
}

