/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.StringIndexedLineReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

public class StringIndexedLineReaderTest
extends TestCase {
    public void testReader() throws IOException {
        StringIndexedLineReader reader = new StringIndexedLineReader(Arrays.asList("foo\n", "bar\n", "baz"));
        StringIndexedLineReaderTest.assertEquals((Object)"foo\nbar\nbaz", (Object)reader.getCharSequence());
        StringIndexedLineReaderTest.assertEquals((int)3, (int)reader.getTotalLines());
        StringIndexedLineReaderTest.assertEquals((int)11, (int)reader.length());
        StringIndexedLineReaderTest.assertEquals((boolean)false, (boolean)reader.isEolTerminated());
        StringIndexedLineReaderTest.assertEquals((int)0, (int)reader.getOffsetForLine(0));
        StringIndexedLineReaderTest.assertEquals((int)4, (int)reader.getOffsetForLine(1));
        StringIndexedLineReaderTest.assertEquals((int)8, (int)reader.getOffsetForLine(2));
        StringIndexedLineReaderTest.assertEquals((int)11, (int)reader.getOffsetForLine(3));
    }

    public void testReaderWithFinalNewline() throws IOException {
        StringIndexedLineReader reader = new StringIndexedLineReader(Arrays.asList("foo\n", "bar\n", "baz\n"));
        StringIndexedLineReaderTest.assertEquals((Object)"foo\nbar\nbaz\n", (Object)reader.getCharSequence());
        StringIndexedLineReaderTest.assertEquals((int)3, (int)reader.getTotalLines());
        StringIndexedLineReaderTest.assertEquals((int)12, (int)reader.length());
        StringIndexedLineReaderTest.assertEquals((boolean)true, (boolean)reader.isEolTerminated());
        StringIndexedLineReaderTest.assertEquals((int)0, (int)reader.getOffsetForLine(0));
        StringIndexedLineReaderTest.assertEquals((int)4, (int)reader.getOffsetForLine(1));
        StringIndexedLineReaderTest.assertEquals((int)8, (int)reader.getOffsetForLine(2));
        StringIndexedLineReaderTest.assertEquals((int)12, (int)reader.getOffsetForLine(3));
    }

    public void testReadingAndSeeking() throws IOException {
        int i;
        ArrayList<String> lines = new ArrayList<String>(10);
        for (int i2 = 0; i2 < 10; ++i2) {
            lines.add("a test line" + i2 + "\n");
        }
        StringIndexedLineReader reader = new StringIndexedLineReader(lines);
        for (i = 0; i < 10; ++i) {
            this.checkLine(reader, i);
        }
        reader.seekLine(5);
        for (i = 5; i < 10; ++i) {
            this.checkLine(reader, i);
        }
    }

    private void checkLine(StringIndexedLineReader reader, int line) throws IOException {
        StringBuffer sb = new StringBuffer();
        int n = reader.readline(sb);
        StringIndexedLineReaderTest.assertEquals((String)("a test line" + line + "\n"), (String)sb.toString());
        StringIndexedLineReaderTest.assertEquals((int)13, (int)n);
    }
}

