/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class StreamIndexedLineReaderTest {
    private File file;

    @Before
    public void setUp() throws Exception {
        this.file = FisheyeTestUtil.createTempFile("testfile");
    }

    @After
    public void tearDown() throws Exception {
        this.file.delete();
    }

    @Test
    public void testSimple() throws Exception {
        this.createNumberedFile(10);
        this.subtestNumberedFile(10);
    }

    @Test
    public void testNoTrailingEOL() throws Exception {
        this.createNumberedFile(10, false);
        this.subtestNumberedFile(10);
    }

    private void subtestNumberedFile(int nlines) throws IOException {
        StreamIndexedLineReader reader = new StreamIndexedLineReader(this.file);
        for (int i = 0; i < nlines; ++i) {
            Assert.assertEquals((int)i, (int)reader.getLineNumber());
            Assert.assertEquals((int)(i + 1), (int)reader.getTotalLines());
            String line = StringUtil.stripEOL((String)reader.readline());
            Assert.assertEquals((String)("" + i), (String)line);
        }
        String eof = reader.readline();
        Assert.assertNull((Object)eof);
        Assert.assertEquals((int)nlines, (int)reader.getTotalLines());
        reader.seekLine(0);
        for (int i = 0; i < nlines; ++i) {
            Assert.assertEquals((int)i, (int)reader.getLineNumber());
            Assert.assertEquals((int)nlines, (int)reader.getTotalLines());
            String line = StringUtil.stripEOL((String)reader.readline());
            Assert.assertEquals((String)("" + i), (String)line);
        }
        eof = reader.readline();
        Assert.assertNull((Object)eof);
        int half = nlines / 2;
        reader.seekLine(half);
        for (int i = half; i < nlines; ++i) {
            Assert.assertEquals((int)i, (int)reader.getLineNumber());
            Assert.assertEquals((int)nlines, (int)reader.getTotalLines());
            String line = StringUtil.stripEOL((String)reader.readline());
            Assert.assertEquals((String)("" + i), (String)line);
        }
        eof = reader.readline();
        Assert.assertNull((Object)eof);
        reader.close();
    }

    private void createNumberedFile(int nlines) throws IOException {
        this.createNumberedFile(nlines, true);
    }

    private void createNumberedFile(int nlines, boolean eofOnLast) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
        for (int i = 0; i < nlines; ++i) {
            out.write((i + "").getBytes());
            if (i >= nlines - 1 && !eofOnLast) continue;
            out.write("\n".getBytes());
        }
        out.close();
    }
}

