/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.OutputStreamBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;
import junit.framework.TestCase;

public class OutputStreamBufferTest
extends TestCase {
    Random rnd = new Random();

    public void testInMemory() throws Exception {
        this.roundTripTest(10, this.randomBytes(10));
    }

    public void testDiskOnly() throws Exception {
        this.roundTripTest(0, this.randomBytes(10));
    }

    public void testCombined() throws Exception {
        this.roundTripTest(4, this.randomBytes(10));
    }

    public void testLarge() throws Exception {
        this.roundTripTest(8192, this.randomBytes(819200));
    }

    public void testCloseAndStream() throws Exception {
        OutputStreamBuffer buf = new OutputStreamBuffer(10);
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)buf, "ASCII"));
        String text = "Lorem epsom ipson dolor sic amet sec in consetum nunc ad valorem. Lorem ipson dolor sic amet sec in consetum nunc ad valorem. Lorem ipson dolor sic";
        out.print(text);
        out.close();
        StringWriter sw = new StringWriter();
        buf.closeAndStream((Writer)sw, "ASCII");
        OutputStreamBufferTest.assertEquals((String)text, (String)sw.toString());
    }

    public void testErrorReadWhileOpen() throws Exception {
        try {
            this.roundTripTest(4, this.randomBytes(10), false);
            OutputStreamBufferTest.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private byte[] randomBytes(int size) {
        byte[] data = new byte[size];
        this.rnd.nextBytes(data);
        return data;
    }

    private void roundTripTest(int bufsize, byte[] data) throws Exception {
        this.roundTripTest(bufsize, data, true);
    }

    private void roundTripTest(int bufsize, byte[] data, boolean closeOut) throws Exception {
        OutputStreamBuffer buf = new OutputStreamBuffer(bufsize);
        buf.write(data);
        if (closeOut) {
            buf.close();
        }
        InputStream in = buf.getInputStream();
        byte[] back = new byte[data.length];
        int pos = 0;
        int read = in.read(back);
        while (read > 0) {
            read = in.read(back, pos += read, data.length - read);
        }
        for (int i = 0; i < data.length; ++i) {
            OutputStreamBufferTest.assertEquals((byte)data[i], (byte)back[i]);
        }
        buf.dispose();
    }
}

