/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class IndexedLineReaderOffsetTest {
    private File file;
    private StreamIndexedLineReader lr;

    @Before
    public void setUp() throws Exception {
        this.file = FisheyeTestUtil.createTempFile("testfile");
    }

    @After
    public void tearDown() throws Exception {
        this.file.delete();
    }

    @Test
    public void testMultiLine() throws Exception {
        this.createFile("foo\nbar\n");
        Assert.assertEquals((int)2, (int)this.lr.getTotalLines());
        Assert.assertEquals((int)0, (int)this.lr.getOffsetForLine(0));
        Assert.assertEquals((int)4, (int)this.lr.getOffsetForLine(1));
        Assert.assertEquals((int)8, (int)this.lr.getOffsetForLine(2));
    }

    @Test
    public void testFileEndings() throws Exception {
        this.createFile("");
        Assert.assertEquals((int)1, (int)this.lr.getTotalLines());
        Assert.assertEquals((int)0, (int)this.lr.getOffsetForLine(0));
        Assert.assertEquals((int)0, (int)this.lr.getOffsetForLine(1));
        this.createFile("\n");
        Assert.assertEquals((int)1, (int)this.lr.getTotalLines());
        Assert.assertEquals((int)0, (int)this.lr.getOffsetForLine(0));
        this.createFile("\na");
        Assert.assertEquals((int)2, (int)this.lr.getTotalLines());
        Assert.assertEquals((int)0, (int)this.lr.getOffsetForLine(0));
        Assert.assertEquals((int)1, (int)this.lr.getOffsetForLine(1));
        Assert.assertEquals((int)2, (int)this.lr.getOffsetForLine(2));
        this.createFile("foo");
        Assert.assertEquals((int)1, (int)this.lr.getTotalLines());
        Assert.assertEquals((int)0, (int)this.lr.getOffsetForLine(0));
        Assert.assertEquals((int)3, (int)this.lr.getOffsetForLine(1));
        this.createFile("foo\n");
        Assert.assertEquals((int)1, (int)this.lr.getTotalLines());
        Assert.assertEquals((int)0, (int)this.lr.getOffsetForLine(0));
        Assert.assertEquals((int)4, (int)this.lr.getOffsetForLine(1));
    }

    private void createFile(String s) throws IOException {
        FileWriter out = new FileWriter(this.file);
        out.write(s);
        out.close();
        this.lr = new StreamIndexedLineReader(this.file);
        this.lr.scanRestOfFile();
    }
}

