/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.atlassian.fecru.matcher.FileMatchers;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.IOHelper;
import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class IOHelperTest {
    private static final String TEST_STRING1 = "This is a test string.";
    private static final String TEST_STRING2 = "CREATE SCHEMA PUBLIC AUTHORIZATION DBA\nCREATE MEMORY TABLE COMMENT(COMMENT_ID INTEGER NOT NULL PRIMARY KEY,CREATE_DATE TIMESTAMP,MESSAGE LONGVARCHAR NOT NULL,DRAFT BOOLEAN NOT NULL,DELETED BOOLEAN NOT NULL,DEFECTRAISED BOOLEAN NOT NULL,DEFECTAPPROVED BOOLEAN NOT NULL,USER_ID INTEGER,REVIEW_ID INTEGER NOT NULL,REPLY_TO_COMMENT_ID INTEGER,CONSTRAINT FK63717A3F252D1475 FOREIGN KEY(REPLY_TO_COMMENT_ID) REFERENCES COMMENT(COMMENT_ID))\nCREATE INDEX IDX_COMMENT_DELETED ON COMMENT(DELETED)\nCREATE INDEX IDX_COMMENT_DRAFT ON COMMENT(DRAFT)\nCREATE INDEX IDX_COMMENT_USER ON COMMENT(USER_ID)\nCREATE INDEX IDX_COMMENT_DEFECTAPPROVED ON COMMENT(DEFECTAPPROVED)\nCREATE INDEX IDX_COMMENT_DEFECTRAISED ON COMMENT(DEFECTRAISED)\nCREATE MEMORY TABLE COMMENT_FIELD(COMMENT_ID INTEGER NOT NULL,FIELD_ID INTEGER NOT NULL,FIELD_ORDER INTEGER NOT NULL,PRIMARY KEY(COMMENT_ID,FIELD_ORDER),CONSTRAINT FKADAF9ADA999D94C6 FOREIGN KEY(COMMENT_ID) REFERENCES COMMENT(COMMENT_ID))\nCREATE MEMORY TABLE COMPLETED_FRX(PARTICIPANT_ID INTEGER NOT NULL,FRX_ID INTEGER NOT NULL,PRIMARY KEY(PARTICIPANT_ID,FRX_ID))\nCREATE MEMORY TABLE CRUPROJECT(PROJECT_ID INTEGER NOT NULL PRIMARY KEY,NAME VARCHAR(255),KEY VARCHAR(255),DEFAULTREPOSITORYNAME VARCHAR(255),ALLOWREVIEWERSTOJOIN BOOLEAN,PERMISSIONSCHEME INTEGER,DEFAULTMODERATOR INTEGER,STOREREVISIONS BOOLEAN)\nCREATE INDEX PROJ_NAME_IDX ON CRUPROJECT(NAME)";
    private File d1;
    private File d2;
    private File d3;
    private File baseDir;
    private File file1;
    private File file2;

    @Before
    public void setUp() throws Exception {
        this.baseDir = FisheyeTestUtil.createTempDir("IOHelperTest");
        this.d1 = new File(this.baseDir, "d1");
        this.d2 = new File(this.d1, "d2");
        this.d3 = new File(this.d2, "d3");
        Assert.assertThat((Object)this.baseDir, FileMatchers.exists());
        junit.framework.Assert.assertTrue((boolean)this.d1.mkdir());
        junit.framework.Assert.assertTrue((boolean)this.d2.mkdir());
        junit.framework.Assert.assertTrue((boolean)this.d3.mkdir());
        this.file1 = new File(this.d3, "file1");
        this.file2 = new File(this.d2, "file2");
        junit.framework.Assert.assertTrue((boolean)this.file1.createNewFile());
        junit.framework.Assert.assertTrue((boolean)this.file2.createNewFile());
        FileWriter writer = new FileWriter(this.file1);
        writer.write(TEST_STRING1);
        writer.close();
        writer = new FileWriter(this.file2);
        writer.write(TEST_STRING2);
        writer.close();
    }

    @After
    public void tearDown() throws Exception {
        FisheyeTestUtil.deleteDir(this.baseDir);
    }

    @Test
    public void testRecursiveDeleteDir() throws Exception {
        IOHelper.recursiveDelete((File)this.baseDir, (int)4, (boolean)false);
        Assert.assertThat((Object)this.baseDir, FileMatchers.exists());
        Assert.assertThat((Object)this.file1, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.file2, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.d3, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.d2, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.d1, (Matcher)CoreMatchers.not(FileMatchers.exists()));
    }

    @Test
    public void testRecursiveDeleteDirDeleteThis() throws Exception {
        IOHelper.recursiveDelete((File)this.baseDir, (int)4, (boolean)true);
        Assert.assertThat((Object)this.baseDir, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.file1, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.file2, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.d3, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.d2, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)this.d1, (Matcher)CoreMatchers.not(FileMatchers.exists()));
    }

    @Test
    public void testCopyFileToString() throws Exception {
        String str = IOHelper.copyFileToString((Charset)Charsets.UTF_8, (File)this.file1);
        junit.framework.Assert.assertTrue((boolean)str.equals(TEST_STRING1));
    }

    @Test
    public void testMkdirs() throws Exception {
        junit.framework.Assert.assertFalse((boolean)IOHelper.mkdirs((File)this.d1));
        junit.framework.Assert.assertFalse((boolean)IOHelper.mkdirs(null));
        try {
            IOHelper.mkdirs((File)this.file1);
            junit.framework.Assert.fail((String)"created a directory where a file was");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOHelper.recursiveDelete((File)this.baseDir, (int)4, (boolean)true);
        junit.framework.Assert.assertTrue((boolean)IOHelper.mkdirs((File)this.d3));
        Assert.assertThat((Object)this.baseDir, FileMatchers.exists());
        Assert.assertThat((Object)this.d3, FileMatchers.exists());
        Assert.assertThat((Object)this.d2, FileMatchers.exists());
        Assert.assertThat((Object)this.d1, FileMatchers.exists());
    }

    @Test
    public void testClose() throws Exception {
        CloseMe c1 = new CloseMe(false);
        CloseMe c2 = new CloseMe(false);
        IOHelper.close((Closeable[])new Closeable[]{c1, null, c2});
        junit.framework.Assert.assertTrue((boolean)c1.closed);
        junit.framework.Assert.assertTrue((boolean)c2.closed);
        CloseMe c3 = new CloseMe(false);
        IOHelper.close((Closeable[])new Closeable[]{c3});
        junit.framework.Assert.assertTrue((boolean)c3.closed);
        CloseMe c4 = new CloseMe(true);
        CloseMe c5 = new CloseMe(false);
        IOHelper.close((Closeable[])new Closeable[]{c4, c5});
        junit.framework.Assert.assertFalse((boolean)c4.closed);
        junit.framework.Assert.assertTrue((boolean)c5.closed);
    }

    @Test
    public void testEnsureDirectoryExists() throws Exception {
        File file = new File(this.baseDir, "mySubfolder");
        Assert.assertThat((String)"subfolder should not exist prior to the test", (Object)file, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        File subdir = IOHelper.ensureDirectoryExists((File)file);
        Assert.assertThat((String)"subfolder should exist after the test", (Object)file, (Matcher)CoreMatchers.allOf(FileMatchers.exists(), FileMatchers.isDirectory()));
        Assert.assertThat((Object)subdir, (Matcher)CoreMatchers.equalTo((Object)file));
    }

    @Test
    public void testEnsureDirectoryExistsSubfolder() throws Exception {
        File expectedFile = new File(this.baseDir, "mySubfolder");
        Assert.assertThat((String)"subfolder should not exist prior to the test", (Object)expectedFile, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        File subdir = IOHelper.ensureDirectoryExists((File)this.baseDir, (String)"mySubfolder");
        Assert.assertThat((String)"subfolder should exist after the test", (Object)expectedFile, (Matcher)CoreMatchers.allOf(FileMatchers.exists(), FileMatchers.isDirectory()));
        Assert.assertThat((Object)subdir, (Matcher)CoreMatchers.equalTo((Object)expectedFile));
    }

    @Test
    public void testDeleteFiles() throws Exception {
        File toBeRemovedFile = new File(this.baseDir, "toBeRemovedFile");
        File toBeKeptFile = new File(this.baseDir, "toBeKeptFile");
        IOHelper.touch((File)toBeRemovedFile);
        IOHelper.touch((File)toBeKeptFile);
        IOHelper.deleteFiles((File)this.baseDir, (FileFilter)new WildcardFileFilter("toBeRemoved*"));
        Assert.assertThat((Object)toBeRemovedFile, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((Object)toBeKeptFile, FileMatchers.exists());
    }

    private class CloseMe
    implements Closeable {
        boolean closed = false;
        boolean die = false;

        private CloseMe(boolean die) {
            this.die = die;
        }

        @Override
        public void close() throws IOException {
            if (this.die) {
                throw new RuntimeException("Die you bastard");
            }
            this.closed = true;
        }
    }
}

