/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class BufferedRandomAccessInputStreamTest {
    private File file;

    @Before
    public void setUp() throws Exception {
        this.file = FisheyeTestUtil.createTempFile("testfile");
    }

    @After
    public void tearDown() throws Exception {
        this.file.delete();
    }

    @Test
    public void testFilePointer() throws Exception {
        this.fillFile(0);
        RandomAccessFile ra = new RandomAccessFile(this.file, "r");
        Assert.assertEquals((long)0L, (long)ra.getFilePointer());
        Assert.assertEquals((int)-1, (int)ra.read());
        Assert.assertEquals((long)0L, (long)ra.getFilePointer());
        BufferedRandomAccessInputStream bstream = new BufferedRandomAccessInputStream(this.file, 10);
        Assert.assertEquals((long)0L, (long)bstream.getFilePointer());
        Assert.assertEquals((int)-1, (int)bstream.read());
        Assert.assertEquals((long)0L, (long)bstream.getFilePointer());
        this.fillFile(1);
        ra = new RandomAccessFile(this.file, "r");
        Assert.assertEquals((long)0L, (long)ra.getFilePointer());
        ra.read();
        Assert.assertEquals((long)1L, (long)ra.getFilePointer());
        Assert.assertEquals((int)-1, (int)ra.read());
        Assert.assertEquals((long)1L, (long)ra.getFilePointer());
        bstream = new BufferedRandomAccessInputStream(this.file, 10);
        Assert.assertEquals((long)0L, (long)bstream.getFilePointer());
        bstream.read();
        Assert.assertEquals((long)1L, (long)bstream.getFilePointer());
        Assert.assertEquals((int)-1, (int)bstream.read());
        Assert.assertEquals((long)1L, (long)bstream.getFilePointer());
    }

    @Test
    public void testFoo() throws Exception {
        this.fillFile(100);
        this.assertContentsOkay(1024, 100);
        this.assertContentsOkay(101, 100);
        this.assertContentsOkay(100, 100);
        this.assertContentsOkay(99, 100);
        this.assertContentsOkay(50, 100);
    }

    private void assertContentsOkay(int aBufferSize, int aFileSize) throws IOException {
        BufferedRandomAccessInputStream stream = new BufferedRandomAccessInputStream(this.file, aBufferSize);
        Assert.assertEquals((long)aFileSize, (long)stream.length());
        stream.close();
        this.assertContentsByRead1(aBufferSize, aFileSize);
        this.assertContentsByRead2(aBufferSize, aFileSize / 2, aFileSize);
        this.assertContentsByRead2(aBufferSize, aFileSize - 1, aFileSize);
        this.assertContentsByRead2(aBufferSize, aFileSize, aFileSize);
        this.assertContentsByRead2(aBufferSize, aFileSize + 1, aFileSize);
        this.assertContentsByRead2(aBufferSize, aFileSize * 2, aFileSize);
        this.assertContentsByRead2(aBufferSize, aBufferSize, aFileSize);
        this.assertContentsByRead2(aBufferSize, aBufferSize / 2, aFileSize);
        this.assertContentsByRead2(aBufferSize, aBufferSize - 1, aFileSize);
        this.assertContentsByRead2(aBufferSize, aBufferSize, aFileSize);
        this.assertContentsByRead2(aBufferSize, aBufferSize + 1, aFileSize);
        this.assertContentsByRead2(aBufferSize, aBufferSize * 2, aFileSize);
    }

    private void assertContentsByRead1(int aBufferSize, int aFileSize) throws IOException {
        BufferedRandomAccessInputStream stream = new BufferedRandomAccessInputStream(this.file, aBufferSize);
        for (int i = 0; i < aFileSize; ++i) {
            Assert.assertEquals((long)i, (long)stream.getFilePointer());
            int c = stream.read();
            Assert.assertTrue((c != -1 ? 1 : 0) != 0);
            Assert.assertEquals((int)(i & 0xFF), (int)c);
        }
        Assert.assertEquals((long)aFileSize, (long)stream.getFilePointer());
        Assert.assertTrue((stream.read() == -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)stream.skip(100L));
        Assert.assertEquals((long)aFileSize, (long)stream.getFilePointer());
        Assert.assertTrue((stream.read() == -1 ? 1 : 0) != 0);
        this.subtestSeek(stream, 0L);
        this.subtestSeek(stream, aFileSize - 1);
        this.subtestSeek(stream, aFileSize / 2);
        this.subtestSeek(stream, aFileSize - 1);
        this.subtestSeek(stream, 0L);
        stream.seek((long)aFileSize);
        Assert.assertEquals((int)-1, (int)stream.read());
        this.subtestSkip(stream, aFileSize, aBufferSize / 10);
        this.subtestSkip(stream, aFileSize, aBufferSize / 3);
        this.subtestSkip(stream, aFileSize, aBufferSize / 2);
        this.subtestSkip(stream, aFileSize, aBufferSize - 1);
        this.subtestSkip(stream, aFileSize, aBufferSize);
        this.subtestSkip(stream, aFileSize, aBufferSize + 1);
        this.subtestSkip(stream, aFileSize, aBufferSize * 2);
        stream.close();
    }

    private void subtestSkip(BufferedRandomAccessInputStream aStream, int aFileSize, int aSkipbytes) throws IOException {
        aStream.seek(0L);
        for (int i = 0; i < aFileSize; i += aSkipbytes) {
            Assert.assertEquals((long)i, (long)aStream.getFilePointer());
            int c = aStream.read();
            Assert.assertTrue((c != -1 ? 1 : 0) != 0);
            Assert.assertEquals((int)(i & 0xFF), (int)c);
            ++i;
            aStream.skip((long)aSkipbytes);
        }
    }

    private void subtestSeek(BufferedRandomAccessInputStream aStream, long aOffset) throws IOException {
        aStream.seek(aOffset);
        Assert.assertEquals((long)(aOffset & 0xFFL), (long)aStream.read());
    }

    private void assertContentsByRead2(int aFileBufferSize, int aByteBufferSize, int aFileSize) throws IOException {
        byte[] buf = new byte[aByteBufferSize];
        BufferedRandomAccessInputStream stream = new BufferedRandomAccessInputStream(this.file, aFileBufferSize);
        int loop = 0;
        int i = 0;
        while (i < aFileSize) {
            Assert.assertEquals((long)i, (long)stream.getFilePointer());
            int nread = stream.read(buf);
            Assert.assertTrue((nread != -1 ? 1 : 0) != 0);
            int j = 0;
            while (j < nread) {
                byte c = buf[j];
                Assert.assertEquals((String)("at index " + i + " at loop " + loop), (int)(i & 0xFF), (int)c);
                ++j;
                ++i;
            }
            ++loop;
        }
        Assert.assertEquals((long)aFileSize, (long)stream.getFilePointer());
        Assert.assertTrue((stream.read(buf) == -1 ? 1 : 0) != 0);
        stream.close();
    }

    private void fillFile(int nbytes) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
        for (int i = 0; i < nbytes; ++i) {
            out.write(i & 0xFF);
        }
        out.close();
    }
}

