/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.BufferedCharSequence;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.RandomAccessIOStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class BufferedCharSequenceTest {
    private File file;

    @Before
    public void setUp() throws Exception {
        this.file = FisheyeTestUtil.createTempFile("testfile");
    }

    @After
    public void tearDown() throws Exception {
        this.file.delete();
    }

    @Test
    public void testNormal() throws Exception {
        this.fillFile(100);
        BufferedCharSequence mcs = new BufferedCharSequence((RandomAccessIOStream)new BufferedRandomAccessInputStream(this.file));
        Assert.assertTrue(((long)mcs.length() == this.file.length() ? 1 : 0) != 0);
        for (int j = 0; j <= 50; ++j) {
            CharSequence cs = mcs.subSequence(j, 100 - j);
            Assert.assertEquals((int)cs.length(), (int)(100 - 2 * j));
            for (int i = j; i < 100 - j; ++i) {
                Assert.assertEquals((String)("i=" + i + ",j=" + j), (int)(i & 0xFF), (int)cs.charAt(i - j));
            }
        }
        String content = "I wish I fisheye was more dish I";
        this.fillFile(content);
        mcs = new BufferedCharSequence((RandomAccessIOStream)new BufferedRandomAccessInputStream(this.file));
        Assert.assertEquals((String)content, (String)mcs.toString());
    }

    @Test
    public void testExceptional() throws Exception {
        this.fillFile(100);
        BufferedCharSequence mcs = new BufferedCharSequence((RandomAccessIOStream)new BufferedRandomAccessInputStream(this.file));
        try {
            mcs.charAt(-1);
            Assert.fail((String)"IOOE expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            mcs.charAt(mcs.length());
            Assert.fail((String)"IOOE expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            mcs.subSequence(0, mcs.length() + 1);
            Assert.fail((String)"IOOE expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            mcs.subSequence(1, 0);
            Assert.fail((String)"IOOE expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void fillFile(int nbytes) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
        for (int i = 0; i < nbytes; ++i) {
            out.write(i & 0xFF);
        }
        out.close();
    }

    private void fillFile(String string) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(this.file));
        out.print(string);
        out.close();
    }
}

