/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AntGlobQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.EntityRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.HasTermQuery3;
import com.cenqua.fisheye.infinitydb.query3.NotQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.PerRepoLuceneJoinQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.RegexQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.util.AntGlob;
import com.infinitydb.Attribute;
import com.infinitydb.Cu;
import com.infinitydb.EntityClass;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.search.Query;

public class Query3EqualityTest
extends TestCase {
    private static final EntityClass ENTITY1 = new EntityClass(1L);
    private static final EntityClass ENTITY2 = new EntityClass(2L);

    public void testBooleanQueries() {
        TermQuery3 t1_1 = new TermQuery3(ENTITY1, "foo", null);
        TermQuery3 t1_2 = new TermQuery3(ENTITY1, "foo", null);
        TermQuery3 t2 = new TermQuery3(ENTITY1, "bar", null);
        AndQuery3 q1 = new AndQuery3();
        q1.addClause((Query3)t1_1);
        q1.addClause((Query3)t2);
        AndQuery3 q2 = new AndQuery3();
        q2.addClause((Query3)t1_2);
        q2.addClause((Query3)t2);
        AndQuery3 q3 = new AndQuery3();
        q3.addClause((Query3)t2);
        OrQuery3 q4 = new OrQuery3();
        q4.addClause((Query3)t1_1);
        q4.addClause((Query3)t2);
        Query3EqualityTest.subtestEquality((Query3)q1, (Query3)q2, (Query3)q3);
        Query3EqualityTest.subtestEquality((Query3)q1, (Query3)q2, (Query3)q4);
    }

    public void testAntGlobQuery() {
        AntGlobQuery3 a = new AntGlobQuery3(ENTITY1, ENTITY2, new AntGlob("foo"));
        AntGlobQuery3 a2 = new AntGlobQuery3(ENTITY1, ENTITY2, new AntGlob("foo"));
        AntGlobQuery3 b1 = new AntGlobQuery3(ENTITY2, ENTITY2, new AntGlob("foo"));
        AntGlobQuery3 b2 = new AntGlobQuery3(ENTITY1, ENTITY1, new AntGlob("foo"));
        AntGlobQuery3 b3 = new AntGlobQuery3(ENTITY1, ENTITY2, new AntGlob("foobar"));
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b3);
    }

    public void testAnyLongRangeQuery() {
        AnyLongRangeQuery3 a = new AnyLongRangeQuery3(ENTITY1, 1L, true, 100L, true);
        AnyLongRangeQuery3 a2 = new AnyLongRangeQuery3(ENTITY1, 1L, true, 100L, true);
        AnyLongRangeQuery3 b1 = new AnyLongRangeQuery3(ENTITY2, 1L, true, 100L, true);
        AnyLongRangeQuery3 b2 = new AnyLongRangeQuery3(ENTITY1, 2L, true, 100L, true);
        AnyLongRangeQuery3 b3 = new AnyLongRangeQuery3(ENTITY1, 1L, false, 100L, true);
        AnyLongRangeQuery3 b4 = new AnyLongRangeQuery3(ENTITY1, 1L, true, 101L, true);
        AnyLongRangeQuery3 b5 = new AnyLongRangeQuery3(ENTITY1, 1L, true, 100L, false);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b3);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b4);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b5);
    }

    public void testHasTermQuery3() {
        HasTermQuery3 a = new HasTermQuery3(ENTITY1);
        HasTermQuery3 a2 = new HasTermQuery3(ENTITY1);
        HasTermQuery3 b1 = new HasTermQuery3(ENTITY2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b1);
    }

    public void tesTermQuery3() {
        TermQuery3 a = new TermQuery3(ENTITY1, "foo", null);
        TermQuery3 a2 = new TermQuery3(ENTITY1, "foo", null);
        TermQuery3 b1 = new TermQuery3(ENTITY2, "foo", null);
        TermQuery3 b2 = new TermQuery3(ENTITY1, "foof", null);
        TermQuery3 b3 = new TermQuery3(ENTITY1, "foo", new Attribute(1L));
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b3);
    }

    public void testPerRepoLuceneJoingQuery3() throws Exception {
        Query q1 = this.testLuceneQuery("foo", "bar");
        Query q2 = this.testLuceneQuery("foo", "bar");
        PerRepoLuceneJoinQuery3 a = new PerRepoLuceneJoinQuery3(q1, LuceneIndexes.CONTENT);
        PerRepoLuceneJoinQuery3 a1 = new PerRepoLuceneJoinQuery3(q1, LuceneIndexes.CONTENT);
        PerRepoLuceneJoinQuery3 a2 = new PerRepoLuceneJoinQuery3(q2, LuceneIndexes.CONTENT);
        PerRepoLuceneJoinQuery3 b1 = new PerRepoLuceneJoinQuery3(this.testLuceneQuery("fooz", "bar"), LuceneIndexes.CONTENT);
        PerRepoLuceneJoinQuery3 b2 = new PerRepoLuceneJoinQuery3(this.testLuceneQuery("foo", "barr"), LuceneIndexes.CONTENT);
        PerRepoLuceneJoinQuery3 b3 = new PerRepoLuceneJoinQuery3(q1, LuceneIndexes.DIFFTEXT);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b3);
    }

    private Query testLuceneQuery(String field, String text) throws Exception {
        return LuceneUtils.parsePhrase((String)text, (String)field, (Analyzer)new WhitespaceAnalyzer());
    }

    public void testNotQuery() {
        TermQuery3 x1 = new TermQuery3(ENTITY1, "foo", null);
        TermQuery3 x2 = new TermQuery3(ENTITY1, "foo", null);
        TermQuery3 y1 = new TermQuery3(ENTITY2, "foo", null);
        HasTermQuery3 y2 = new HasTermQuery3(ENTITY2);
        NotQuery3 a = new NotQuery3((Query3)x1);
        NotQuery3 a1 = new NotQuery3((Query3)x1);
        NotQuery3 a2 = new NotQuery3((Query3)x2);
        NotQuery3 b1 = new NotQuery3((Query3)y1);
        NotQuery3 b2 = new NotQuery3((Query3)y2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a2, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b2);
    }

    public void testRegexQuery() {
        RegexQuery3 a = new RegexQuery3(ENTITY1, ENTITY2, Pattern.compile("foo"));
        RegexQuery3 a1 = new RegexQuery3(ENTITY1, ENTITY2, Pattern.compile("foo"));
        RegexQuery3 b1 = new RegexQuery3(ENTITY2, ENTITY2, Pattern.compile("foo"));
        RegexQuery3 b2 = new RegexQuery3(ENTITY1, ENTITY1, Pattern.compile("foo"));
        RegexQuery3 b3 = new RegexQuery3(ENTITY1, ENTITY2, Pattern.compile("fooz"));
        RegexQuery3 b4 = new RegexQuery3(ENTITY1, ENTITY2, Pattern.compile("foo", 2));
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b3);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b4);
    }

    public void testTermLookupQuery3() {
        TermLookupQuery3 a = new TermLookupQuery3(ENTITY1, ENTITY2, "foo", null);
        TermLookupQuery3 a1 = new TermLookupQuery3(ENTITY1, ENTITY2, "foo", null);
        TermLookupQuery3 b1 = new TermLookupQuery3(ENTITY2, ENTITY2, "foo", null);
        TermLookupQuery3 b2 = new TermLookupQuery3(ENTITY1, ENTITY1, "foo", null);
        TermLookupQuery3 b3 = new TermLookupQuery3(ENTITY1, ENTITY2, "fooz", null);
        TermLookupQuery3 b4 = new TermLookupQuery3(ENTITY1, ENTITY2, "foo", new Attribute(1L));
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b1);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b2);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b3);
        Query3EqualityTest.subtestEquality((Query3)a, (Query3)a1, (Query3)b4);
    }

    public void testEntityRangeQuery3() {
        Cu cu1 = Cu.alloc().append(1L);
        Cu cu2 = Cu.alloc().append(2L);
        EntityRangeQuery3 a0 = new EntityRangeQuery3(ENTITY1, null, null);
        EntityRangeQuery3 a1 = new EntityRangeQuery3(ENTITY1, null, null);
        EntityRangeQuery3 b = new EntityRangeQuery3(ENTITY2, cu1, null);
        EntityRangeQuery3 c = new EntityRangeQuery3(ENTITY2, null, cu2);
        EntityRangeQuery3 d0 = new EntityRangeQuery3(ENTITY2, cu1, cu2);
        EntityRangeQuery3 d1 = new EntityRangeQuery3(ENTITY2, cu1, cu2);
        Query3EqualityTest.subtestEquality((Query3)a0, (Query3)a1, (Query3)b);
        Query3EqualityTest.subtestEquality((Query3)d0, (Query3)d1, (Query3)c);
    }

    private static void subtestEquality(Query3 a, Query3 equals, Query3 notQuery3) {
        Query3EqualityTest.assertEquals((Object)a, (Object)equals);
        Query3EqualityTest.assertEquals((int)a.hashCode(), (int)equals.hashCode());
        Query3EqualityTest.assertTrue((!a.equals((Object)notQuery3) ? 1 : 0) != 0);
        Query3EqualityTest.assertTrue((!equals.equals((Object)notQuery3) ? 1 : 0) != 0);
    }
}

