/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.infinitydb.query3.EntityRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.infinitydb.Attribute;
import com.infinitydb.Cu;
import com.infinitydb.CuAppendable;
import com.infinitydb.EntityClass;
import com.infinitydb.InfinityDB;
import com.infinitydb.ItemSpace;
import java.io.IOException;
import java.util.EnumMap;
import junit.framework.TestCase;
import org.apache.lucene.search.IndexSearcher;

public class EntityRangeQuery3Test
extends TestCase {
    private EntityClass e103 = new EntityClass(103L);
    private EntityClass e104 = new EntityClass(104L);
    private Attribute a1 = new Attribute(1L);
    private Attribute a2 = new Attribute(2L);
    private ItemSpace db;

    private static EnumMap<LuceneIndexes, IndexSearcher> newSearchers() {
        return new EnumMap<LuceneIndexes, IndexSearcher>(LuceneIndexes.class);
    }

    protected void setUp() throws Exception {
        InfinityDB dbfile = FisheyeTestUtil.createTempDBForWrite();
        this.db = dbfile;
        this.db.insert(Cu.alloc((Object)this.e103).append(1L));
        this.db.insert(Cu.alloc((Object)this.e103).append(1L).append((CuAppendable)this.a1).append("matt"));
        this.db.insert(Cu.alloc((Object)this.e103).append(1L).append((CuAppendable)this.a2).append("quail"));
        this.db.insert(Cu.alloc((Object)this.e103).append(2L));
        this.db.insert(Cu.alloc((Object)this.e103).append(2L).append((CuAppendable)this.a1).append("fred"));
        this.db.insert(Cu.alloc((Object)this.e103).append(2L).append((CuAppendable)this.a2).append("blogs"));
        this.db.insert(Cu.alloc((Object)this.e103).append(100L));
        this.db.insert(Cu.alloc((Object)this.e103).append(100L).append((CuAppendable)this.a1).append("john"));
        this.db.insert(Cu.alloc((Object)this.e103).append(100L).append((CuAppendable)this.a2).append("smith"));
        this.db.insert(Cu.alloc((Object)this.e104).append(1L));
        this.db.insert(Cu.alloc((Object)this.e104).append(1L).append("a"));
        this.db.insert(Cu.alloc((Object)this.e104).append(2L));
        this.db.insert(Cu.alloc((Object)this.e104).append(2L).append("a"));
        this.db.insert(Cu.alloc((Object)this.e104).append(100L));
        this.db.insert(Cu.alloc((Object)this.e104).append(100L).append("a"));
        dbfile.commit();
    }

    public void testRanges() throws Exception {
        this.subtestRanges(this.e103);
        this.subtestRanges(this.e104);
    }

    private void subtestRanges(EntityClass entity) throws Exception {
        Cu zero = Cu.alloc().append(0L);
        Cu oneDec = Cu.alloc().append(1L);
        oneDec.decrementSuffix(0);
        Cu one = Cu.alloc().append(1L);
        Cu two = Cu.alloc().append(2L);
        Cu twoInc = Cu.alloc().append(2L);
        twoInc.incrementSuffix(0);
        Cu hundred = Cu.alloc().append(100L);
        Cu hundredInc = Cu.alloc().append(100L);
        hundredInc.incrementSuffix(0);
        this.subtestRanges(entity, zero, null, false, new int[]{1, 2, 100});
        this.subtestRanges(entity, one, null, true, new int[]{1, 2, 100});
        this.subtestRanges(entity, zero, two, false, new int[]{1});
        this.subtestRanges(entity, oneDec, two, false, new int[]{1});
        this.subtestRanges(entity, one, two, true, new int[]{1});
        this.subtestRanges(entity, one, one, false, new int[0]);
        this.subtestRanges(entity, oneDec, twoInc, false, new int[]{1, 2});
        this.subtestRanges(entity, zero, hundred, false, new int[]{1, 2});
        this.subtestRanges(entity, two, hundred, true, new int[]{2});
        this.subtestRanges(entity, two, hundredInc, true, new int[]{2, 100});
        this.subtestRanges(entity, twoInc, hundredInc, false, new int[]{100});
        this.subtestRanges(entity, zero, hundredInc, false, new int[]{1, 2, 100});
    }

    private void subtestRanges(EntityClass entityClass, Cu start, Cu end, boolean expectIncludesStart, int[] expected) throws Exception {
        EntityRangeQuery3 q = new EntityRangeQuery3(entityClass, start, end);
        ItemSpace space = q.asItemSpace(new Query3.QueryContext(this.db, null, EntityRangeQuery3Test.newSearchers()));
        this.subtestRanges(space, start, end, expectIncludesStart, expected);
    }

    private void subtestRanges(ItemSpace space, Cu start, Cu end, boolean expectIncludesStart, int[] expected) throws IOException {
        if (start != null) {
            EntityRangeQuery3Test.assertEquals((boolean)expectIncludesStart, (boolean)space.exists(start));
        }
        if (end != null) {
            EntityRangeQuery3Test.assertFalse((boolean)space.exists(end));
        }
        int i = 0;
        Cu cu = Cu.alloc();
        while (space.next(cu)) {
            long found = cu.longAt(0);
            EntityRangeQuery3Test.assertEquals((long)expected[i++], (long)found);
        }
        EntityRangeQuery3Test.assertEquals((int)i, (int)expected.length);
    }

    public void testInfinityAppending() throws Exception {
        EntityRangeQuery3 q = this.revidClauseAfter(2);
        ItemSpace space = q.asItemSpace(new Query3.QueryContext(this.db, null, EntityRangeQuery3Test.newSearchers()));
        this.subtestRanges(space, Cu.alloc((long)2L), null, false, new int[]{100});
        q = this.revidClauseAfter(100);
        space = q.asItemSpace(new Query3.QueryContext(this.db, null, EntityRangeQuery3Test.newSearchers()));
        this.subtestRanges(space, Cu.alloc((long)100L), null, false, new int[0]);
    }

    private EntityRangeQuery3 revidClauseAfter(int revid) {
        Cu start = Cu.alloc().append((long)revid);
        start.incrementSuffix(0);
        Cu end = null;
        return new EntityRangeQuery3(this.e103, start, end);
    }
}

