/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3Params;
import com.cenqua.fisheye.rep.DbException;
import com.infinitydb.Cu;
import com.infinitydb.EntityClass;
import com.infinitydb.ItemSpace;
import java.io.IOException;
import junit.framework.TestCase;

public class AnyLongRangeQuery3Test
extends TestCase {
    private EntityClass e103 = new EntityClass(103L);
    private EntityClass e104 = new EntityClass(104L);
    private ItemSpace db;

    protected void setUp() throws Exception {
        this.db = FisheyeTestUtil.createTempDBForWrite();
        this.db.insert(Cu.alloc((Object)this.e103).append(1L).append(1L));
        this.db.insert(Cu.alloc((Object)this.e103).append(1L).append(2L));
        this.db.insert(Cu.alloc((Object)this.e103).append(2L).append(2L));
        this.db.insert(Cu.alloc((Object)this.e103).append(1151667760852L).append(3L));
        this.db.insert(Cu.alloc((Object)this.e103).append(1151667760852L).append(4L));
        this.db.insert(Cu.alloc((Object)this.e104).append(1L).append(5L));
    }

    public void testBoundries() throws Exception {
        this.assertQuery(new int[]{1, 2}, 0L, true, 1L, true);
        this.assertQuery(new int[]{1, 2}, 0L, false, 1L, true);
        this.assertQuery(new int[0], 0L, false, 1L, false);
        this.assertQuery(new int[0], 0L, true, 1L, false);
        this.assertQuery(new int[]{1, 2}, 1L, true, 2L, true);
        this.assertQuery(new int[]{2}, 1L, false, 2L, true);
        this.assertQuery(new int[0], 1L, false, 2L, false);
        this.assertQuery(new int[]{1, 2}, 1L, true, 2L, false);
        this.assertQuery(new int[]{2, 3, 4}, 2L, true, Long.MAX_VALUE, false);
        this.assertQuery(new int[]{3, 4}, 2L, false, Long.MAX_VALUE, false);
    }

    private void assertQuery(int[] expected, long start, boolean incStart, long endPk, boolean incEnd) throws DbException, IOException {
        AnyLongRangeQuery3 q = new AnyLongRangeQuery3(this.e103, start, incStart, endPk, incEnd);
        ItemSpace is = q.asItemSpace(new Query3Params(this.db, null));
        int i = 0;
        Cu cu = Cu.alloc();
        int counted = 0;
        while (is.next(cu)) {
            ++counted;
            long l = cu.longAt(0);
            AnyLongRangeQuery3Test.assertEquals((long)expected[i++], (long)l);
        }
        AnyLongRangeQuery3Test.assertEquals((int)expected.length, (int)counted);
    }

    private void dump(ItemSpace db) throws IOException {
        Cu cu = Cu.alloc();
        while (db.next(cu)) {
            System.out.println(cu);
        }
    }
}

