/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.CountingDelegatorFactory;
import com.cenqua.fisheye.infinitydb.MockUST;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UniqueStringTableDelegatorFactoryBuilderTest {
    static final String key = "com.atlassian.fisheye.UniqueStringTable.DelegatorFactory";
    String old = System.getProperty("com.atlassian.fisheye.UniqueStringTable.DelegatorFactory");

    @Before
    public void before() {
        this.old = System.getProperty(key);
    }

    @After
    public void after() {
        if (this.old != null) {
            System.setProperty(key, this.old);
        } else {
            System.getProperties().remove(key);
        }
    }

    @Test
    public void defaultsCorrrectlyWithNoKey() throws Exception {
        System.getProperties().remove(key);
        Assert.assertTrue((UniqueStringTable.DelegatorFactory.Builder.get() == UniqueStringTable.DelegatorFactory.DEFAULT_FACTORY ? 1 : 0) != 0);
    }

    @Test
    public void defaultsCorrrectlyIfIncorrectClass() throws Exception {
        System.setProperty(key, this.getClass().getCanonicalName());
        Assert.assertTrue((UniqueStringTable.DelegatorFactory.Builder.get() == UniqueStringTable.DelegatorFactory.DEFAULT_FACTORY ? 1 : 0) != 0);
    }

    @Test
    public void identity() throws Exception {
        MockUST table = new MockUST();
        Assert.assertSame((Object)((Object)table), (Object)new UniqueStringTable.DelegatorFactory.Identity().delegate((UniqueStringTable)table));
    }

    @Test
    public void usesConfiguredFactory() throws Exception {
        String name = CountingDelegatorFactory.class.getName();
        System.setProperty(key, name);
        CountingDelegatorFactory.reset();
        UniqueStringTable.DelegatorFactory delegatorFactory = UniqueStringTable.DelegatorFactory.Builder.get();
        Assert.assertSame(CountingDelegatorFactory.class, delegatorFactory.getClass());
        Assert.assertEquals((long)0L, (long)CountingDelegatorFactory.get());
        delegatorFactory.delegate((UniqueStringTable)new MockUST());
        Assert.assertEquals((long)1L, (long)CountingDelegatorFactory.get());
    }
}

