/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.AbstractUniqueStringTable;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class MemoryUST
extends AbstractUniqueStringTable {
    private long nextId = 1L;
    private Map<Long, String> store = new HashMap<Long, String>();
    private Map<String, Long> invStore = new HashMap<String, Long>();
    private boolean enabled = true;

    MemoryUST() {
    }

    public Object getTableId() {
        return null;
    }

    public String get(long id) throws DbException {
        this.validateEnabled();
        return this.store.get(id);
    }

    private void validateEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("Memory UST is disabled");
        }
    }

    public long find(@Nullable String s) throws DbException {
        this.validateEnabled();
        if (this.invStore.containsKey(s)) {
            return this.invStore.get(s);
        }
        return -1L;
    }

    public long add(@Nullable String s) throws DbException {
        this.validateEnabled();
        long id = this.find(s);
        if (id != -1L) {
            return id;
        }
        id = this.nextId++;
        this.store.put(id, s);
        this.invStore.put(s, id);
        return id;
    }

    public long getMaxId() throws DbException {
        return this.nextId - 1L;
    }

    public SortedIntSet search(Pattern pattern) throws DbException {
        return null;
    }

    public SortedIntSet search(AntGlob pattern) throws DbException {
        return null;
    }

    public <V extends UniqueStringTable.Visitor> V visit(V v, int startId) throws DbException {
        return null;
    }

    public void clearCaches() {
        this.store.clear();
        this.invStore.clear();
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }
}

