/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.infinitydb.Cu;
import com.infinitydb.InfinityDB;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public abstract class InfDbReplayTestBase {
    Pattern COMMAND = Pattern.compile("([a-z]+)( [0-9]+(?:,[0-9]+)*)?");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replayInfinityDbOperations(InfinityDB db, File recording) throws IOException {
        LineNumberReader in = new LineNumberReader(new FileReader(recording));
        Cu cu = Cu.alloc();
        try {
            String line = in.readLine();
            while (line != null) {
                this.replayOperation(db, cu, line);
                line = in.readLine();
            }
        }
        finally {
            cu.dispose();
        }
        in.close();
    }

    private void replayOperation(InfinityDB db, Cu cu, String line) throws IOException {
        Matcher m = this.COMMAND.matcher(line);
        if (m.matches()) {
            String cmd = m.group(1);
            String args = m.groupCount() > 1 ? m.group(2) : null;
            String string = args = args != null ? args.trim() : args;
            if ("cursor".equals(cmd)) {
                char[] cuChars = this.getCharArray(args);
                cu.clear().putDirect(0, cuChars, 0, cuChars.length);
            } else if ("next".equals(cmd)) {
                if (args != null) {
                    db.next(cu, Integer.parseInt(args));
                } else {
                    db.next(cu);
                }
            } else if ("delete".equals(cmd)) {
                db.delete(cu);
            } else if ("exists".equals(cmd)) {
                db.exists(cu);
            } else if ("first".equals(cmd)) {
                if (args != null) {
                    db.first(cu, Integer.parseInt(args));
                } else {
                    db.first(cu);
                }
            } else if ("insert".equals(cmd)) {
                db.insert(cu);
            } else if ("previous".equals(cmd)) {
                if (args != null) {
                    db.previous(cu, Integer.parseInt(args));
                } else {
                    db.previous(cu);
                }
            } else if ("update".equals(cmd)) {
                db.update(cu, Integer.parseInt(args));
            } else if ("commit".equals(cmd)) {
                db.commit();
            } else if ("rollback".equals(cmd)) {
                db.rollBack();
            } else {
                Assert.fail((String)("unsupported command " + line));
            }
        } else {
            Assert.fail((String)("unsupported command " + line));
        }
    }

    private char[] getCharArray(String charArray) {
        String[] charStrings = charArray.trim().split(",");
        char[] chars = new char[charStrings.length];
        int i = 0;
        for (String s : charStrings) {
            chars[i++] = (char)Integer.parseInt(s);
        }
        return chars;
    }
}

