/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.InfDbIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.infinitydb.Cu;
import com.infinitydb.CuAppendable;
import com.infinitydb.EntityClass;
import com.infinitydb.InfinityDB;
import com.infinitydb.ItemSpace;
import java.io.File;
import java.io.IOException;
import java.util.ListIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InfDbIterableTest {
    private InfinityDbHandle dbh;
    private File dbFile;
    private static final EntityClass ENTITY = new EntityClass(100L);
    private static final EntityClass PREV_ENTITY = new EntityClass(99L);
    private static final EntityClass NEXT_ENTITY = new EntityClass(101L);

    @Before
    public void initDb() throws Exception {
        this.dbFile = File.createTempFile("infdbiterable", "bin");
        this.dbh = new InfinityDbHandle(this.dbFile);
        InfinityDB.create((String)this.dbFile.getAbsolutePath(), (boolean)true).close();
        ItemSpace db = this.dbh.get();
        Cu cu = Cu.alloc();
        for (long val = 1000L; val < 2000L; ++val) {
            cu.clear().append((CuAppendable)PREV_ENTITY).append(val + "prev");
            db.insert(cu);
            cu.clear().append((CuAppendable)ENTITY).append(val + "target");
            db.insert(cu);
            cu.clear().append((CuAppendable)NEXT_ENTITY).append(val + "next");
            db.insert(cu);
        }
        this.dbh.commit();
    }

    private InfDbIterable<String> createIterable(Cu cu, int offset) {
        return new InfDbIterable<String>(this.dbh, cu, offset){

            public String getElement(Cu cu, int valueOffset) throws IOException, DbException {
                return cu.stringAt(valueOffset);
            }
        };
    }

    @After
    public void destroyDb() throws Exception {
        this.dbh.close();
        if (!this.dbFile.delete()) {
            this.dbFile.deleteOnExit();
        }
    }

    @Test
    public void testForwardIteration() throws Exception {
        String expectedVal;
        Cu cu = Cu.alloc().append((CuAppendable)ENTITY);
        InfDbIterable<String> iterable = this.createIterable(cu, cu.length());
        long expected = 1000L;
        ListIterator it = iterable.iterator();
        Assert.assertFalse((boolean)it.hasPrevious());
        while (it.hasNext()) {
            expectedVal = expected + "target";
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((Object)expectedVal, it.next());
            ++expected;
        }
        Assert.assertEquals((long)2000L, (long)expected);
        expected = 1000L;
        it = iterable.iterator();
        while (it.hasNext()) {
            expectedVal = expected + "target";
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((Object)expectedVal, it.next());
            ++expected;
        }
        Assert.assertEquals((long)2000L, (long)expected);
    }

    @Test
    public void testReverseIteration() throws Exception {
        String expectedVal;
        Cu cu = Cu.alloc().append((CuAppendable)ENTITY);
        int offset = cu.length();
        cu.appendInfinity();
        InfDbIterable<String> iterable = this.createIterable(cu, offset);
        long expected = 1999L;
        ListIterator it = iterable.iterator();
        Assert.assertFalse((boolean)it.hasNext());
        while (it.hasPrevious()) {
            expectedVal = expected + "target";
            Assert.assertTrue((boolean)it.hasPrevious());
            Assert.assertEquals((Object)expectedVal, it.previous());
            --expected;
        }
        Assert.assertEquals((long)999L, (long)expected);
        expected = 1999L;
        it = iterable.iterator();
        Assert.assertFalse((boolean)it.hasNext());
        while (it.hasPrevious()) {
            expectedVal = expected + "target";
            Assert.assertTrue((boolean)it.hasPrevious());
            Assert.assertEquals((Object)expectedVal, it.previous());
            --expected;
        }
        Assert.assertEquals((long)999L, (long)expected);
    }

    @Test
    public void testBackAndForthIteration() throws Exception {
        Cu cu = Cu.alloc().append((CuAppendable)ENTITY);
        int offset = cu.length();
        cu.append("1750target");
        InfDbIterable<String> iterable = this.createIterable(cu, offset);
        ListIterator it = iterable.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasPrevious());
        Assert.assertEquals((Object)"1751target", it.next());
        Assert.assertEquals((Object)"1752target", it.next());
        Assert.assertEquals((Object)"1753target", it.next());
        Assert.assertEquals((Object)"1752target", it.previous());
        Assert.assertEquals((Object)"1751target", it.previous());
        Assert.assertEquals((Object)"1752target", it.next());
        Assert.assertEquals((Object)"1753target", it.next());
    }
}

