/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.infinitydb.Cu;
import com.infinitydb.CuAppendable;
import com.infinitydb.ItemSpace;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class DbScrubber {
    public static void main(String[] args) {
        File d0File = new File("data0.bin");
        if (!d0File.exists()) {
            System.err.println("data0 file not found at " + d0File.getAbsolutePath());
            System.exit(1);
        }
        InfinityDbHandle old = new InfinityDbHandle(d0File);
        File newFile = new File("data0_new.bin");
        newFile.delete();
        InfinityDbHandle clean = new InfinityDbHandle(newFile);
        System.out.println("Scrubbing " + d0File.getAbsolutePath() + " to " + newFile.getAbsolutePath());
        try {
            ItemSpace dbOld = old.get();
            ItemSpace dbClean = clean.get();
            Cu cu = Cu.alloc();
            dbOld.first(cu, 0);
            do {
                System.out.println(cu.toString());
                dbClean.insert(cu);
            } while (dbOld.next(cu, 0));
            clean.commit();
            dbOld.last(cu);
            do {
                System.out.println(cu.toString());
                dbClean.insert(cu);
            } while (dbOld.previous(cu, 0));
            HashSet<String> usernames = new HashSet<String>();
            cu.clear();
            cu.append((CuAppendable)DB0EAV.INDEX_EMAIL_TO_FEUSER);
            int cuLen = cu.length();
            while (dbOld.next(cu, cuLen)) {
                int skip = cu.skipString(cuLen);
                skip = cu.skipAttribute(skip);
                usernames.add(cu.stringAt(skip));
            }
            for (String username : usernames) {
                cu.clear();
                cu.append((CuAppendable)DB0EAV.FEUSER);
                cu.append(username);
                cuLen = cu.length();
                while (dbOld.next(cu, cuLen)) {
                    System.out.println(cu.toString());
                    dbClean.insert(cu);
                }
            }
            clean.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

