/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.CachingUniqueStringTable;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CachingUniqueStringTableTest {
    @Mock
    private UniqueStringTable delegate;
    private CachingUniqueStringTable cachingUniqueStringTable;

    @Before
    public void setUp() throws Exception {
        this.cachingUniqueStringTable = new CachingUniqueStringTable(this.delegate);
    }

    @Test
    public void testGetReturnsNullIfDelegateIsNull() throws Exception {
        long nonExistingId = 1234567L;
        Mockito.when((Object)this.delegate.get(Matchers.anyLong())).thenReturn(null);
        String result = this.cachingUniqueStringTable.get(nonExistingId);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testGetReturnsValueIfDelegateHasValue() throws Exception {
        long id = 1L;
        String value = "existing value";
        Mockito.when((Object)this.delegate.get(Matchers.eq((long)id))).thenReturn((Object)value);
        String result = this.cachingUniqueStringTable.get(id);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)value));
    }

    @Test
    public void testGetCachesValueIfDelegateHasValue() throws Exception {
        long id = 1L;
        String value = "existing value";
        Mockito.when((Object)this.delegate.get(Matchers.eq((long)id))).thenReturn((Object)value);
        this.cachingUniqueStringTable.get(id);
        String result = this.cachingUniqueStringTable.get(id);
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)value));
        ((UniqueStringTable)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).get(Matchers.anyLong());
    }

    @Test(expected=DbException.class)
    public void testGetReThrowsDBException() throws Exception {
        long id = 1L;
        Mockito.when((Object)this.delegate.get(Matchers.eq((long)id))).thenThrow(new Throwable[]{new DbException("potential exception")});
        this.cachingUniqueStringTable.get(id);
    }

    @Test(expected=RuntimeException.class)
    public void testGetReThrowsRuntimeException() throws Exception {
        long id = 1L;
        Mockito.when((Object)this.delegate.get(Matchers.eq((long)id))).thenThrow(new Throwable[]{new IllegalStateException("any runtime exception")});
        this.cachingUniqueStringTable.get(id);
    }
}

