/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.CachingUniqueStringTable;
import com.cenqua.fisheye.infinitydb.MemoryUST;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CachingUSTTest {
    private MemoryUST memoryUst;

    @Before
    public void setUp() throws Exception {
        this.memoryUst = new MemoryUST();
    }

    @Test
    public void testBasicCaching() throws Exception {
        CachingUniqueStringTable cacheUst = new CachingUniqueStringTable((UniqueStringTable)this.memoryUst);
        String testString = "hello";
        long id = cacheUst.add(testString);
        String delegateResult = this.memoryUst.get(id);
        Assert.assertEquals((String)"Underlying Cache not working", (String)testString, (String)delegateResult);
        this.memoryUst.disable();
        String result = cacheUst.get(id);
        Assert.assertEquals((String)"Cache not working", (String)testString, (String)result);
    }

    @Test
    public void testMultipleAdds() throws Exception {
        CachingUniqueStringTable cacheUst = new CachingUniqueStringTable((UniqueStringTable)this.memoryUst);
        String testString = "hello";
        long id = cacheUst.add(testString);
        String delegateResult = this.memoryUst.get(id);
        Assert.assertEquals((String)"Underlying Cache not working", (String)testString, (String)delegateResult);
        this.memoryUst.disable();
        long id2 = cacheUst.add(testString);
        Assert.assertEquals((String)"Cache not working", (long)id, (long)id2);
    }
}

