/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.infinitydb.BitSetItemSpace;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.infinitydb.Cu;
import com.infinitydb.ItemSpace;
import com.infinitydb.VolatileItemSpace;
import junit.framework.TestCase;

public class BitSetItemSpaceTest
extends TestCase {
    public void testExistsInBitSetItemSpace() throws Exception {
        SegmentedIntSet bs = new SegmentedIntSet();
        bs.set(10);
        bs.set(11);
        bs.set(12);
        this.subtestSpace((ItemSpace)new BitSetItemSpace((SortedIntSet)bs));
    }

    public void testExistsInInfDbItemSpace() throws Exception {
        this.subtestExistsInInfDbItemSpace((ItemSpace)new VolatileItemSpace());
        this.subtestExistsInInfDbItemSpace((ItemSpace)FisheyeTestUtil.createTempDBForWrite());
    }

    private void subtestExistsInInfDbItemSpace(ItemSpace is) throws Exception {
        is.insert(Cu.alloc((long)10L));
        is.insert(Cu.alloc((long)11L));
        is.insert(Cu.alloc((long)12L));
        this.subtestSpace(is);
    }

    private void subtestSpace(ItemSpace is) throws Exception {
        this.assertContains(true, 10, is);
        this.assertContains(true, 11, is);
        this.assertContains(true, 12, is);
        this.assertContains(false, -1, is);
        this.assertContains(false, 0, is);
        this.assertContains(false, 1, is);
        this.assertContains(false, 8, is);
        this.assertContains(false, 9, is);
        this.assertContains(false, 13, is);
        this.assertContains(false, 14, is);
    }

    private void assertContains(boolean expected, int i, ItemSpace is) throws Exception {
        Cu cu = Cu.alloc((long)i);
        BitSetItemSpaceTest.assertEquals((boolean)expected, (boolean)is.exists(cu));
    }
}

