/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.hibernate;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.upgrade.UpgradeConfig;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUserManager;
import com.cenqua.dbutils.Util;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class UserCommitterMappingUpgradeTest {
    private LegacyUserManager um;
    private File dbDir;
    private DefaultDBControl dbControl;

    @After
    public void tearDown() throws Exception {
        try {
            AppConfig.getsConfig().closeDB();
            TestFishEyeInstances.deleteData0();
        }
        finally {
            FileUtils.deleteTree((File)this.dbDir);
        }
    }

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.setupSanity1AppConfig();
        File dir = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/upgradeMapping/");
        File src = new File(dir, "data0.bin_");
        File dataDir = AppConfig.getVarDataDir();
        if (!dataDir.exists()) {
            Assert.assertTrue((boolean)dataDir.mkdirs());
        }
        File db0File = new File(AppConfig.getVarDataDir(), "data0.bin");
        IOHelper.copy((File)src, (File)db0File);
        TestFishEyeInstances.loadSanity1RootConfig();
        this.um = new LegacyUserManager(UpgradeConfig.INSTANCE.getDB0Handle());
        this.dbDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/upgradeMapping/crudb");
        if (this.dbDir.exists()) {
            FileUtils.deleteTree((File)this.dbDir);
        }
        Assert.assertTrue((boolean)this.dbDir.mkdirs());
        this.dbControl = Util.createDataBase(29, this.dbDir, "db29", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgrade() throws LicensePolicyException, DbException, SQLException, CruDBException {
        Map expected = this.um.getAllLegacyAuthorMappings();
        this.checkMappings(expected);
        this.dbControl.upgrade(30);
        Assert.assertTrue((String)("Should be empty: " + this.um.getAllLegacyAuthorMappings()), (this.um.getAllLegacyAuthorMappings().size() == 0 ? 1 : 0) != 0);
        Connection conn = this.dbControl.getConnection();
        try {
            for (Map.Entry<String, Map<String, String>> user : this.getAllMappings(conn).entrySet()) {
                String username = user.getKey();
                for (Map.Entry<String, String> committers : user.getValue().entrySet()) {
                    String rep = committers.getKey();
                    String committer = committers.getValue();
                    Map userMapping = (Map)expected.get(username);
                    Assert.assertNotNull((String)("Expected mapping for user " + username), (Object)userMapping);
                    Assert.assertEquals((String)committer, (String)((String)userMapping.remove(rep)));
                    if (userMapping.size() != 0) continue;
                    expected.remove(username);
                }
            }
        }
        finally {
            this.dbControl.closeConnection(conn);
        }
        Assert.assertTrue((String)("should be empty: " + expected), (boolean)expected.isEmpty());
    }

    private void checkMappings(Map<String, Map<String, String>> mappings) throws DbException, LicensePolicyException {
        Assert.assertEquals((int)mappings.size(), (int)3);
        for (String s : new String[]{"a", "b", "c"}) {
            Map<String, String> userMappings = mappings.get(s);
            Assert.assertNotNull(userMappings);
            Assert.assertEquals((int)userMappings.size(), (int)3);
            Assert.assertEquals((String)userMappings.get("RepA"), (String)(s + s));
            Assert.assertEquals((String)userMappings.get("cvs"), (String)(s + s));
            Assert.assertEquals((String)userMappings.get("cvs2"), (String)(s + s));
        }
    }

    private Map<String, Map<String, String>> getAllMappings(Connection conn) throws SQLException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        PreparedStatement psSelect = conn.prepareStatement("Select * from cru_committer_user_mapping");
        ResultSet existing = psSelect.executeQuery();
        while (existing.next()) {
            String user = existing.getString("user_name");
            String committer = existing.getString("committer_name");
            String rep = existing.getString("repository_name");
            HashMap<String, String> userMap = (HashMap<String, String>)result.get(user);
            if (userMap == null) {
                userMap = new HashMap<String, String>();
                result.put(user, userMap);
            }
            userMap.put(rep, committer);
        }
        return result;
    }
}

