/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.DiffSequences;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.TextFileDiffSequences;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.util.TestUtil;
import java.io.File;
import java.util.List;
import junit.framework.TestCase;

public class LineComparatorTest
extends TestCase {
    public void testIdentical() {
        LineComparator.Identical lc = LineComparator.IDENTICAL;
        LineComparatorTest.assertLinesEqual((LineComparator)lc, " the quick  brown  ", " the quick  brown  ");
        LineComparatorTest.assertLinesNotEqual((LineComparator)lc, " the quick  brown  ", "foo");
    }

    public void testIgnoreSpaceChange() {
        LineComparator lc = LineComparator.fromDiffOption((DiffOpts)new DiffOpts("b"));
        LineComparatorTest.assertLinesEqual(lc, " the quick  brown  ", " the quick  brown  ");
        LineComparatorTest.assertLinesEqual(lc, " the  \t quick  brown  ", " the quick\tbrown");
        LineComparatorTest.assertLinesNotEqual(lc, " the quick  brown  ", "the quick  brown  ");
        LineComparatorTest.assertLinesNotEqual(lc, " the quick  brown  ", " thequick  brown  ");
        LineComparatorTest.assertLinesNotEqual(lc, " the quick  brown  ", "foo");
    }

    public void testIgnoreAllSpace() {
        LineComparator lc = LineComparator.fromDiffOption((DiffOpts)new DiffOpts("w"));
        LineComparatorTest.assertLinesEqual(lc, " the quick  brown  ", " the quick  brown  ");
        LineComparatorTest.assertLinesEqual(lc, " the  \t quick  brown  ", " the quick\tbrown");
        LineComparatorTest.assertLinesEqual(lc, " the quick  brown  ", "the\nquick\tbrown");
        LineComparatorTest.assertLinesEqual(lc, " the quick  brown  ", "thequickbrown");
        LineComparatorTest.assertLinesNotEqual(lc, " the quick  brown  ", "foo");
    }

    public void testIgnoreLines() throws Exception {
        LineComparatorTest.subtestIgnoreLines("wB", 0, 0, new String[]{"a", "b"}, new String[]{"a", "b"});
        LineComparatorTest.subtestIgnoreLines("wB", 0, 0, new String[]{"first line", "second line"}, new String[]{"first line ", "second  line"});
        LineComparatorTest.subtestIgnoreLines("wB", 1, 1, new String[]{"first line", "second line"}, new String[]{"first line ", "", "second  line"});
        LineComparatorTest.subtestIgnoreLines("B", 1, 1, new String[]{"first line", "second line"}, new String[]{"", "first line", "second line"});
        LineComparatorTest.subtestIgnoreLines("B", 1, 0, new String[]{"", "first line", "second line"}, new String[]{"inserted", "more", "blah", "foo", "thingie", "", "first line", "second line"});
    }

    public void testMissingStartOfFileRegression() throws Exception {
        HunkList hunks = LineComparatorTest.subtestIgnoreLines("B", 1, 0, new String[]{"", "first line", "second line"}, new String[]{"inserted", "more", "blah", "foo", "thingie", "", "first line", "second line"});
        List sections = hunks.getSections();
        LineComparatorTest.assertEquals((int)2, (int)sections.size());
        Section section = (Section)sections.get(0);
        LineComparatorTest.assertTrue((boolean)section.isDiff());
        LineComparatorTest.assertTrue((boolean)section.getHunk().isAdd());
        LineComparatorTest.assertEquals((int)0, (int)section.getToStart());
        LineComparatorTest.assertEquals((int)5, (int)section.getToLength());
        section = (Section)sections.get(1);
        LineComparatorTest.assertTrue((boolean)section.isCommonSubsequence());
        LineComparatorTest.assertEquals((int)0, (int)section.getFromStart());
        LineComparatorTest.assertEquals((int)3, (int)section.getFromLength());
        LineComparatorTest.assertEquals((int)5, (int)section.getToStart());
        LineComparatorTest.assertEquals((int)3, (int)section.getToLength());
    }

    private static HunkList subtestIgnoreLines(String mode, int numDiffs, int numIgnoredHunks, String[] alines, String[] blines) throws Exception {
        File fileA = FisheyeTestUtil.createTempFile("filea");
        File fileB = FisheyeTestUtil.createTempFile("fileb");
        TestUtil.writeToFile(fileA, alines);
        TestUtil.writeToFile(fileB, blines);
        StreamIndexedLineReader aReader = new StreamIndexedLineReader(fileA);
        StreamIndexedLineReader bReader = new StreamIndexedLineReader(fileB);
        TextFileDiffSequences seqs = new TextFileDiffSequences((IndexedLineReader)aReader, (IndexedLineReader)bReader, LineComparator.fromDiffOption((DiffOpts)new DiffOpts(mode)));
        HunkList hunks = Diff.diff((DiffSequences)seqs);
        LineComparatorTest.assertEquals((int)numDiffs, (int)hunks.size());
        int ignoredCount = 0;
        List sects = hunks.getSections();
        for (int i = 0; i < sects.size(); ++i) {
            Section sect = (Section)sects.get(i);
            LineComparatorTest.assertTrue((String)("section " + i + "=" + sect), (sect.getFromStart() >= 0 ? 1 : 0) != 0);
            LineComparatorTest.assertTrue((String)("section " + i + "=" + sect), (sect.getToStart() >= 0 ? 1 : 0) != 0);
            LineComparatorTest.assertTrue((String)("section " + i + "=" + sect), (sect.getFromLength() >= 0 ? 1 : 0) != 0);
            LineComparatorTest.assertTrue((String)("section " + i + "=" + sect), (sect.getToLength() >= 0 ? 1 : 0) != 0);
            if (!sect.getHunk().isIgnored()) continue;
            ++ignoredCount;
        }
        LineComparatorTest.assertEquals((int)numIgnoredHunks, (int)ignoredCount);
        aReader.close();
        bReader.close();
        fileA.delete();
        fileB.delete();
        return hunks;
    }

    private static void assertLinesEqual(LineComparator lc, String a, String b) {
        StringBuffer ab = new StringBuffer(a);
        StringBuffer bb = new StringBuffer(b);
        LineComparatorTest.assertTrue((boolean)lc.equals(ab, bb));
        ab = new StringBuffer(a);
        bb = new StringBuffer(b);
        LineComparatorTest.assertEquals((int)lc.hashcode(ab), (int)lc.hashcode(bb));
    }

    private static void assertLinesNotEqual(LineComparator lc, String a, String b) {
        StringBuffer ab = new StringBuffer(a);
        StringBuffer bb = new StringBuffer(b);
        LineComparatorTest.assertFalse((boolean)lc.equals(ab, bb));
    }
}

