/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.EDiff;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.TestUtil;
import java.io.File;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class EDiffTest {
    File fileA;
    File fileB;
    StreamIndexedLineReader inA;
    StreamIndexedLineReader inB;

    @Before
    public void setUp() throws Exception {
        this.fileA = FisheyeTestUtil.createTempFile("filea");
        this.fileB = FisheyeTestUtil.createTempFile("fileb");
        String[] linesA = new String[]{"commonline", "", " This was the original first line  ", "and #this came second", "commonline"};
        String[] linesB = new String[]{"commonline", "", "  This is the  first line", " and second line  ", "commonline"};
        TestUtil.writeToFile(this.fileA, linesA);
        TestUtil.writeToFile(this.fileB, linesB);
        this.inA = new StreamIndexedLineReader(this.fileA);
        this.inA.scanRestOfFile();
        this.inB = new StreamIndexedLineReader(this.fileB);
        this.inB.scanRestOfFile();
    }

    @After
    public void tearDown() throws Exception {
        this.inA.close();
        this.inB.close();
        this.fileA.delete();
        this.fileB.delete();
    }

    @Test
    public void testEDiffRegions() throws Exception {
        EDiff diff = new EDiff(this.inA.getCharSequence(), this.inB.getCharSequence(), new DiffOpts());
        diff.doDiff();
        RegionList regionsA = diff.getOriginalRegions();
        Assert.assertEquals((int)5, (int)regionsA.size());
        int aline1 = 0;
        int aline2 = aline1 + 11;
        int aline3 = aline2 + 1;
        int aline4 = aline3 + 36;
        Iterator iA = regionsA.iterator();
        EDiffTest.assertRegionsEquals(aline3 + 0, aline3 + 1, (Region)iA.next());
        EDiffTest.assertRegionsEquals(aline3 + 6, aline3 + 9, (Region)iA.next());
        EDiffTest.assertRegionsEquals(aline3 + 13, aline3 + 23, (Region)iA.next());
        EDiffTest.assertRegionsEquals(aline3 + 33, aline3 + 35, (Region)iA.next());
        EDiffTest.assertRegionsEquals(aline4 + 4, aline4 + 15, (Region)iA.next());
        Assert.assertFalse((boolean)iA.hasNext());
        RegionList regionsB = diff.getRevisedRegions();
        Assert.assertEquals((int)5, (int)regionsB.size());
        int bline1 = 0;
        int bline2 = bline1 + 11;
        int bline3 = bline2 + 1;
        int bline4 = bline3 + 26;
        Iterator iB = regionsB.iterator();
        EDiffTest.assertRegionsEquals(bline3 + 0, bline3 + 2, (Region)iB.next());
        EDiffTest.assertRegionsEquals(bline3 + 7, bline3 + 9, (Region)iB.next());
        EDiffTest.assertRegionsEquals(bline3 + 13, bline3 + 15, (Region)iB.next());
        EDiffTest.assertRegionsEquals(bline4 + 0, bline4 + 1, (Region)iB.next());
        EDiffTest.assertRegionsEquals(bline4 + 11, bline4 + 18, (Region)iB.next());
        Assert.assertFalse((boolean)iB.hasNext());
    }

    private static void assertRegionsEquals(int start, int end, Region r) {
        Assert.assertEquals((int)start, (int)r.getStart());
        Assert.assertEquals((int)end, (int)r.getEnd());
        String ediff = r.getPropertyValue("ediff");
        Assert.assertEquals((String)"changed", (String)ediff);
    }
}

