/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffSequences;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.ListDiffSequences;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.TextFileDiffSequences;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.util.TestUtil;
import java.io.File;
import java.util.Iterator;
import junit.framework.TestCase;

public class DiffTest
extends TestCase {
    public static final String[] empty = new String[0];
    public static final String[] original = new String[]{"[1] one", "[2] two", "[3] three", "[4] four", "[5] five", "[6] six", "[7] seven", "[8] eight", "[9] nine"};
    public static final String[] rev1 = new String[]{"[1] one", "[2] two", "[4] four", "[5] five", "[6] six", "[7] seven", "[8] eight"};
    public static final String[] rev2 = new String[]{"[1] one", "[2] two", "[3] three", "[4] four", "[5] five", "[6] six", "[7] seven revised", "[8] eight revised"};
    public static final String[] rev3 = new String[]{"[1] one", "[2] two", "[2.5] two revised", "[3] three", "[4] four", "[5] five", "[6] six", "[7] seven", "[8] eight", "[9] nine", "[10] ten revised", "[11] eleven revised"};
    public static final String[] rev4 = new String[]{"[3] three", "[5] five", "[6] six", "[7] seven", "[8] eight", "[9] nine"};
    public static final String[] lao = new String[]{"The Way that can be told of is not the eternal Way;", "The name that can be named is not the eternal name.", "The Nameless is the origin of Heaven and Earth;", "The Named is the mother of all things.", "Therefore let there always be non-being,", "  so we may see their subtlety,", "And let there always be being,", "  so we may see their outcome.", "The two are the same,", "But after they are produced,", "  they have different names."};
    public static final String[] tzu = new String[]{"The Nameless is the origin of Heaven and Earth;", "The named is the mother of all things.", "", "Therefore let there always be non-being,", "  so we may see their subtlety,", "And let there always be being,", "  so we may see their outcome.", "The two are the same,", "But after they are produced,", "  they have different names.", "They both may be called deep and profound.", "Deeper and more profound,", "The door of all subtleties!"};

    public void testDeleteAll() {
        HunkList chunks = DiffTest.diff(original, empty);
        DiffTest.assertEquals((int)1, (int)chunks.size());
        Hunk hunk = chunks.getHunk(0);
        DiffTest.assertTrue((boolean)hunk.isDelete());
        DiffTest.assertEquals((Object)new Hunk(0, 0, original.length, 0), (Object)hunk);
    }

    public void testEmpties() {
        HunkList chunks = DiffTest.diff(empty, empty);
        DiffTest.assertEquals((int)0, (int)chunks.size());
    }

    public void testTextFileDiff() throws Exception {
        File fileLao = FisheyeTestUtil.createTempFile("lao");
        File fileTzu = FisheyeTestUtil.createTempFile("tzu");
        TestUtil.writeToFile(fileLao, lao);
        TestUtil.writeToFile(fileTzu, tzu);
        StreamIndexedLineReader laoReader = new StreamIndexedLineReader(fileLao);
        StreamIndexedLineReader tzuReader = new StreamIndexedLineReader(fileTzu);
        TextFileDiffSequences seqs = new TextFileDiffSequences((IndexedLineReader)laoReader, (IndexedLineReader)tzuReader, (LineComparator)LineComparator.IDENTICAL);
        DiffTest.assertEquals((int)11, (int)seqs.getOriginalSize());
        DiffTest.assertEquals((int)13, (int)seqs.getRevisedSize());
        DiffTest.assertFalse((boolean)seqs.equal(0, 0));
        DiffTest.assertFalse((boolean)seqs.equal(1, 0));
        DiffTest.assertTrue((boolean)seqs.equal(2, 0));
        DiffTest.assertFalse((boolean)seqs.equal(3, 1));
        DiffTest.assertFalse((boolean)seqs.equal(3, 2));
        DiffTest.assertTrue((boolean)seqs.equal(4, 3));
        DiffTest.assertTrue((boolean)seqs.equal(10, 9));
        DiffTest.assertFalse((boolean)seqs.equal(10, 10));
        HunkList hunks = Diff.diff((DiffSequences)seqs);
        DiffTest.assertLaoTzuHunksOkay(hunks);
        fileLao.delete();
        fileTzu.delete();
    }

    public void testDiffManualExample() throws Exception {
        HunkList hunks = DiffTest.diff(lao, tzu);
        DiffTest.assertLaoTzuHunksOkay(hunks);
    }

    private static void assertLaoTzuHunksOkay(HunkList aHunks) throws Exception {
        DiffTest.assertEquals((int)3, (int)aHunks.size());
        Hunk hunk = aHunks.getHunk(0);
        DiffTest.assertTrue((boolean)hunk.isDelete());
        DiffTest.assertEquals((Object)new Hunk(0, 0, 2, 0), (Object)hunk);
        hunk = aHunks.getHunk(1);
        DiffTest.assertTrue((boolean)hunk.isChange());
        DiffTest.assertEquals((Object)new Hunk(3, 1, 1, 2), (Object)hunk);
        hunk = aHunks.getHunk(2);
        DiffTest.assertTrue((boolean)hunk.isAdd());
        DiffTest.assertEquals((Object)new Hunk(11, 10, 0, 3), (Object)hunk);
        Iterator sections = aHunks.getSections(-1).iterator();
        DiffTest.assertTrue((boolean)sections.hasNext());
        Section section = (Section)sections.next();
        DiffTest.assertTrue((boolean)section.isDiff());
        DiffTest.assertTrue((boolean)sections.hasNext());
        section = (Section)sections.next();
        DiffTest.assertTrue((boolean)section.isCommonSubsequence());
        DiffTest.assertEquals((int)1, (int)section.getHunk().getFromCount());
        DiffTest.assertTrue((boolean)sections.hasNext());
        section = (Section)sections.next();
        DiffTest.assertTrue((boolean)section.isDiff());
        DiffTest.assertTrue((boolean)sections.hasNext());
        section = (Section)sections.next();
        DiffTest.assertTrue((boolean)section.isCommonSubsequence());
        DiffTest.assertEquals((int)7, (int)section.getHunk().getFromCount());
        DiffTest.assertTrue((boolean)sections.hasNext());
        section = (Section)sections.next();
        DiffTest.assertTrue((boolean)section.isDiff());
        DiffTest.assertFalse((boolean)sections.hasNext());
    }

    public void testTwoDeletes() {
        HunkList chunks = DiffTest.diff(original, rev1);
        DiffTest.assertEquals((int)chunks.size(), (int)2);
        Hunk hunk = chunks.getHunk(0);
        DiffTest.assertTrue((boolean)hunk.isDelete());
        DiffTest.assertEquals((Object)new Hunk(2, 2, 1, 0), (Object)hunk);
        hunk = chunks.getHunk(1);
        DiffTest.assertTrue((boolean)hunk.isDelete());
        DiffTest.assertEquals((Object)new Hunk(8, 7, 1, 0), (Object)hunk);
    }

    public void testChangeAtTheEnd() {
        HunkList hunks = DiffTest.diff(original, rev2);
        DiffTest.assertEquals((int)1, (int)hunks.size());
        Hunk hunk = hunks.getHunk(0);
        DiffTest.assertTrue((boolean)hunk.isChange());
        DiffTest.assertEquals((Object)new Hunk(6, 6, 3, 2), (Object)hunk);
    }

    public void testTwoAdds() {
        HunkList hunks = DiffTest.diff(original, rev3);
        DiffTest.assertEquals((int)2, (int)hunks.size());
        Hunk hunk = hunks.getHunk(0);
        DiffTest.assertTrue((boolean)hunk.isAdd());
        DiffTest.assertEquals((Object)new Hunk(2, 2, 0, 1), (Object)hunk);
        hunk = hunks.getHunk(1);
        DiffTest.assertTrue((boolean)hunk.isAdd());
        DiffTest.assertEquals((Object)new Hunk(9, 10, 0, 2), (Object)hunk);
    }

    public void testDeletesFromTop() {
        HunkList hunks = DiffTest.diff(original, rev4);
        DiffTest.assertEquals((int)2, (int)hunks.size());
        Hunk hunk = hunks.getHunk(0);
        DiffTest.assertTrue((boolean)hunk.isDelete());
        DiffTest.assertEquals((Object)new Hunk(0, 0, 2, 0), (Object)hunk);
        hunk = hunks.getHunk(1);
        DiffTest.assertTrue((boolean)hunk.isDelete());
        DiffTest.assertEquals((Object)new Hunk(3, 1, 1, 0), (Object)hunk);
    }

    public void testLargeTotallyDifferent() {
        int i;
        int size = 1024;
        String[] a = new String[1024];
        String[] b = new String[1024];
        int c = 0;
        for (i = 0; i < a.length; ++i) {
            a[i] = Integer.toString(c++);
        }
        for (i = 0; i < b.length; ++i) {
            b[i] = Integer.toString(c++);
        }
        HunkList hunks = DiffTest.diff(a, b);
        DiffTest.assertEquals((int)1, (int)hunks.size());
        Hunk hunk = hunks.getHunk(0);
        DiffTest.assertTrue((boolean)hunk.isChange());
        DiffTest.assertEquals((Object)new Hunk(0, 0, 1024, 1024), (Object)hunk);
    }

    public static HunkList diff(String[] aOriginal, String[] aRev) {
        return Diff.diff((DiffSequences)new ListDiffSequences((Object[])aOriginal, (Object[])aRev));
    }
}

