/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.RevInfoEAV;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import java.io.File;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class RevInfoEAVTest {
    private InfinityDbHandle dbh;
    private CommonStringTables commonTables;
    private LicenseEnforcer lm = new NullLicenseEnforcer();

    @Before
    public void setUp() throws Exception {
        File f = FisheyeTestUtil.createTempDB("db");
        this.dbh = new InfinityDbHandle(f);
        this.commonTables = new CommonStringTables((UniqueStringTableFactory)this.dbh);
    }

    @After
    public void tearDown() throws Exception {
        this.dbh.close();
    }

    @Test
    public void testCRUD() throws Exception {
        RevInfoEAV eav = new RevInfoEAV(this.dbh, this.commonTables, true, this.lm);
        Path path = new Path((CharSequence)"test/testfiles/simple/simple1.txt");
        RcsFileHistory hist = FisheyeTestUtil.parseTestRcsFile(path).getHistory();
        RcsRevisionInfo src = hist.getCvsRevision("1.1");
        RevInfoKey key = new RevInfoKey(path, "1.1");
        Assert.assertEquals((int)-1, (int)eav.findRevID(key));
        eav.update(hist);
        this.dbh.commit();
        int revid = src.getRevID();
        Assert.assertEquals((int)revid, (int)eav.findRevID(key));
        CvsRevInfo ri = eav.load(key);
        Assert.assertNotNull((Object)ri);
        Assert.assertEquals((int)ri.getRevID(), (int)src.getRevID());
        Assert.assertEquals((Object)ri.getPath(), (Object)src.getPath());
        Assert.assertEquals((String)ri.getRevision(), (String)src.getRevision());
        Assert.assertEquals((String)ri.getAuthor(), (String)src.getAuthor());
        Assert.assertEquals((String)ri.getComment(), (String)src.getComment());
        Assert.assertNull((Object)eav.getChangeSet(revid));
        CvsCSID csid = CvsCSID.parse((String)"main:matt:20041021120000");
        eav.updateChangeset((FileRevision)ri, csid);
        this.dbh.commit();
        Assert.assertEquals((Object)csid, (Object)eav.getChangeSet(revid));
    }

    @Test
    public void testChangesets() throws Exception {
        RevInfoEAV eav = new RevInfoEAV(this.dbh, this.commonTables, true, this.lm);
        Path path = new Path((CharSequence)"test/testfiles/simple/simple1.txt");
        RcsFileHistory hist = FisheyeTestUtil.parseTestRcsFile(path).getHistory();
        RcsRevisionInfo src = hist.getCvsRevision("1.1");
        RevInfoKey key = new RevInfoKey(path, "1.1");
        Assert.assertEquals((int)-1, (int)eav.findRevID(key));
        eav.update(hist);
        this.dbh.commit();
        int revid = src.getRevID();
        Assert.assertEquals((int)revid, (int)eav.findRevID(key));
        CvsRevInfo ri = eav.load(key);
        Assert.assertNotNull((Object)ri);
        Assert.assertEquals((int)ri.getRevID(), (int)src.getRevID());
        Assert.assertEquals((Object)ri.getPath(), (Object)src.getPath());
        Assert.assertEquals((String)ri.getRevision(), (String)src.getRevision());
        Assert.assertEquals((String)ri.getAuthor(), (String)src.getAuthor());
        Assert.assertEquals((String)ri.getComment(), (String)src.getComment());
        Assert.assertNull((Object)eav.getChangeSet(revid));
        CvsCSID csid = CvsCSID.parse((String)"main:matt:20041021120000");
        eav.updateChangeset((FileRevision)ri, csid);
        this.dbh.commit();
        Assert.assertEquals((Object)csid, (Object)eav.getChangeSet(revid));
    }
}

