/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.RepositoryModificationTracker;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.cache.CvsFileHistory;
import com.cenqua.fisheye.cvsrep.cache.infdb.FileHistEAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import java.io.File;
import java.util.Collections;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class FileInfoEAVTest {
    private InfDbRevisionInfoCache cache;
    private InfinityDbHandle dbh;

    @Before
    public void setUp() throws Exception {
        File f = FisheyeTestUtil.createTempDir("fileinfoeavtest");
        this.dbh = new InfinityDbHandle(new File(f, "data.bin"));
        IndexingContext indexingContext = (IndexingContext)Mockito.mock(IndexingContext.class);
        RepositoryModificationTracker tracker = (RepositoryModificationTracker)Mockito.mock(RepositoryModificationTracker.class);
        Mockito.when((Object)indexingContext.getRepositoryModificationTracker()).thenReturn((Object)tracker);
        this.cache = new InfDbRevisionInfoCache((RepositoryConfig)Mockito.mock(RepositoryConfig.class), indexingContext, this.dbh, (LicenseEnforcer)new NullLicenseEnforcer());
        this.cache.open();
    }

    @After
    public void tearDown() throws Exception {
        this.dbh.close();
    }

    @Test
    public void testCRUD() throws Exception {
        this.subtestCheckCRUD(new Path((CharSequence)"test/testfiles/simple/simple1.txt"));
        this.subtestCheckCRUD(new Path((CharSequence)"test/testfiles/CRU478/a.txt"));
    }

    private void subtestCheckCRUD(Path path) throws Exception {
        FileHistEAV eav = this.cache.getFileHistEAV();
        RcsFileHistoryFactory.Result hist = FisheyeTestUtil.parseTestRcsFile(path);
        this.cache.index(Collections.singletonList(hist));
        this.cache.commit();
        CvsFileHistory h = eav.load(path, "foo");
        Assert.assertEquals((Object)hist.getHistory().getPath(), (Object)h.getPath());
        Assert.assertEquals((boolean)hist.getHistory().isBinary(), (boolean)h.isBinary());
        Assert.assertEquals((Object)hist.getHistory().getExpand(), (Object)h.getExpand());
        Assert.assertEquals((String)hist.getHistory().getHead(), (String)h.getHead());
        Assert.assertEquals((String)hist.getHistory().getMainBranch(), (String)h.getMainBranch());
    }
}

