/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.cvsrep.cache.CvsHistoryReader;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import junit.framework.TestCase;

public class CvsHistoryReaderTest
extends TestCase {
    public void testCorruptHistoryCRU1205() throws Exception {
        File d = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU1205");
        File f = new File(d, "history1.txt");
        CvsHistoryReader hr = new CvsHistoryReader(f);
        CvsHistoryReader.Record r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt1");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt2");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt4");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt5");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt7");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt8");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt9");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt10");
        r = hr.nextRecord();
        CvsHistoryReaderTest.assertNotNull((Object)r);
        CvsHistoryReaderTest.assertEquals((String)r.fields[1], (String)"matt12");
    }

    public void testFindStartOfLastLine() throws Exception {
        this.assertLastLineOffset("", 0L, -1);
        this.assertLastLineOffset("\n", 0L, 10);
        this.assertLastLineOffset("asd", 0L, 97);
        this.assertLastLineOffset("asd\n", 0L, 97);
        this.assertLastLineOffset("asd\n\r\n", 0L, 97);
        this.assertLastLineOffset("\ndef", 1L, 100);
        this.assertLastLineOffset("abc\ndef", 4L, 100);
        this.assertLastLineOffset("abc\ndef\n", 4L, 100);
        this.assertLastLineOffset("\nabc\ndef", 5L, 100);
        this.assertLastLineOffset("\nabc\ndef\n", 5L, 100);
    }

    private void assertLastLineOffset(String lines, long expectedOffset, int expectedRead) throws Exception {
        File tmpf = FisheyeTestUtil.createTempFile("fisheye-test");
        FileOutputStream out = new FileOutputStream(tmpf);
        out.write(lines.getBytes());
        out.close();
        long offset = CvsHistoryReader.findStartOfLastLine((File)tmpf);
        CvsHistoryReaderTest.assertEquals((long)expectedOffset, (long)offset);
        RandomAccessFile in = new RandomAccessFile(tmpf, "r");
        in.seek(expectedOffset);
        int c = in.read();
        CvsHistoryReaderTest.assertEquals((int)expectedRead, (int)c);
    }
}

