/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.RepositoryModificationTracker;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class CacheTest
extends TestCase {
    public void testChangesets() throws Exception {
        File f = FisheyeTestUtil.createTempDir("db");
        InfinityDbHandle dbh = new InfinityDbHandle(new File(f, "data.bin"));
        IndexingContext indexingContext = (IndexingContext)Mockito.mock(IndexingContext.class);
        RepositoryModificationTracker tracker = (RepositoryModificationTracker)Mockito.mock(RepositoryModificationTracker.class);
        Mockito.when((Object)indexingContext.getRepositoryModificationTracker()).thenReturn((Object)tracker);
        InfDbRevisionInfoCache db = new InfDbRevisionInfoCache((RepositoryConfig)Mockito.mock(RepositoryConfig.class), indexingContext, dbh, (LicenseEnforcer)new NullLicenseEnforcer());
        db.open();
        Path path1 = new Path((CharSequence)"test/testfiles/simple/simple1.txt");
        Path path2 = new Path((CharSequence)"test/testfiles/simple/simple2.txt");
        RevInfoKey revkey1 = new RevInfoKey(path1, "1.1");
        RevInfoKey revkey2 = new RevInfoKey(path2, "1.1");
        ArrayList<RcsFileHistoryFactory.Result> hists = new ArrayList<RcsFileHistoryFactory.Result>();
        hists.add(FisheyeTestUtil.parseTestRcsFile(path1));
        hists.add(FisheyeTestUtil.parseTestRcsFile(path2));
        CvsCSID csid = CvsCSID.parse((String)"main:matt:20041021120000");
        db.index(hists);
        ArrayList<CvsRevInfo> revInfos = new ArrayList<CvsRevInfo>();
        revInfos.add(db.findRevInfo(revkey1));
        revInfos.add(db.findRevInfo(revkey2));
        db.appendToChangeSet(csid, revInfos);
        db.commit();
        IntList revids = db.getChangeSet(csid);
        CacheTest.assertEquals((int)2, (int)revids.size());
        CacheTest.assertTrue((boolean)revids.contains(db.getCommonRevInfoDAO().getRevId(revkey1)));
        CacheTest.assertTrue((boolean)revids.contains(db.getCommonRevInfoDAO().getRevId(revkey2)));
        dbh.close();
    }
}

