/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import antlr.TokenStreamException;
import com.cenqua.fisheye.cvsrep.AbstractRCSParseListener;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RcsStringToken;
import com.cenqua.fisheye.cvsrep.RcsUtil;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

public class RCSParseDebugDumper
extends AbstractRCSParseListener {
    private final PrintStream mOut;
    private final StringBuffer mPrefix = new StringBuffer();
    private final BufferedRandomAccessInputStream mFile;

    public RCSParseDebugDumper(PrintStream aOut, BufferedRandomAccessInputStream aFile) {
        this.mOut = aOut;
        this.mFile = aFile;
    }

    public void startAdmin() {
        this.println("start admin");
        this.push();
    }

    public void adminHead(String num) {
        this.println("head " + num);
    }

    public void adminBranch(String num) {
        this.println("branch " + num);
    }

    public void adminAccess(String id) {
        this.println("access " + id);
    }

    public void adminSymbol(String symbol, String number) {
        this.println("symbol " + symbol + ":" + number);
    }

    public void adminComment(RcsStringToken comment) throws TokenStreamException {
        this.println("comment " + RcsUtil.rcsStringToString((RcsStringToken)comment, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (BufferedRandomAccessInputStream)this.mFile));
    }

    public void adminExpand(String str) {
        this.println("expand " + str);
    }

    public void endAdmin() {
        this.pop();
        this.println("end admin");
    }

    public void startDelta(String num, String date, String author) {
        this.println("start delta " + num + " " + date + " " + author);
        this.push();
    }

    public void deltaBranch(String num) {
        this.println("branch " + num);
    }

    public void deltaNext(String num) {
        this.println("next " + num);
    }

    public void endDelta() {
        this.pop();
        this.println("end delta");
    }

    private void push() {
        this.mPrefix.append(" ");
    }

    private void pop() {
        this.mPrefix.setLength(this.mPrefix.length() - 1);
    }

    private void println(String aMsg) {
        this.mOut.print(this.mPrefix);
        this.mOut.println(aMsg);
        this.mOut.flush();
    }
}

