/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;

public class LineReaderTest
extends TestCase {
    public void testEolAtEndOfFile() throws IOException {
        this.assertReading(new String[0], false, false, "");
        this.assertReading(new String[0], false, true, "");
        this.assertReading(new String[]{"foo"}, false, false, "foo");
        this.assertReading(new String[]{"foo"}, false, true, "foo");
        this.assertReading(new String[]{"foo\n"}, true, false, "foo\n");
        this.assertReading(new String[]{"foo\n"}, true, true, "foo\n");
        this.assertReading(new String[]{"foo\n", "bar"}, false, false, "foo\nbar");
        this.assertReading(new String[]{"foo\n", "bar"}, false, true, "foo\nbar");
        this.assertReading(new String[]{"foo\n", "bar\n"}, true, false, "foo\nbar\n");
        this.assertReading(new String[]{"foo\n", "bar\n"}, true, true, "foo\nbar\n");
    }

    public void testPushBack() throws Exception {
        String threeLines = "1\n2\n3\n";
        ReaderLineReader in = new ReaderLineReader(LineReader.Mode.MODE_UNIX, (Reader)new StringReader(threeLines));
        LineReaderTest.assertEquals((String)"1\n", (String)in.readLine());
        LineReaderTest.assertEquals((String)"2\n", (String)in.readLine());
        LineReaderTest.assertEquals((String)"3\n", (String)in.readLine());
        in.pushLineBack("3\n");
        in.pushLineBack("2\n");
        in.pushLineBack("1\n");
        LineReaderTest.assertEquals((String)"1\n", (String)in.readLine());
        LineReaderTest.assertEquals((String)"2\n", (String)in.readLine());
        LineReaderTest.assertEquals((String)"3\n", (String)in.readLine());
    }

    private void assertReading(String[] expectedLines, boolean expectTrailingNL, boolean doPushback, String input) throws IOException {
        String line;
        ReaderLineReader in = new ReaderLineReader(LineReader.Mode.MODE_UNIX, (Reader)new StringReader(input));
        int linesRead = 0;
        String last = null;
        while (null != (line = in.readLine())) {
            if (doPushback) {
                in.pushLineBack(line);
                line = in.readLine();
            }
            LineReaderTest.assertTrue((linesRead < expectedLines.length ? 1 : 0) != 0);
            LineReaderTest.assertEquals((String)expectedLines[linesRead], (String)line);
            last = line;
            ++linesRead;
        }
        LineReaderTest.assertEquals((int)expectedLines.length, (int)linesRead);
        if (last == null) {
            LineReaderTest.assertFalse((boolean)expectTrailingNL);
        } else {
            LineReaderTest.assertEquals((boolean)expectTrailingNL, (boolean)last.endsWith("\n"));
        }
    }
}

