/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.KeywordExpandingLineWriter;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.LineWriter;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.RcsUtil;
import com.cenqua.fisheye.cvsrep.Revision;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class KeywordExpanderTest
extends TestCase {
    RcsRevisionInfo mRcsInfo;
    File mRealFile;
    String mFullPath;
    private String symrev = null;

    protected void setUp() throws Exception {
        Path path = new Path((CharSequence)"test/foo/file.txt");
        RcsFileHistory hist = new RcsFileHistory();
        hist.setPath(path);
        Revision rev = new Revision("1.2");
        this.mRcsInfo = new RcsRevisionInfo(hist, rev);
        this.mRcsInfo.setAuthor("matt");
        this.mRcsInfo.setDate(RcsUtil.parseDate((String)"2004.08.23.00.53.55"));
        this.mRcsInfo.setState("Exp");
        this.mRcsInfo.setComment("the comment!");
        hist.add(this.mRcsInfo);
        this.mRealFile = new File("/opt/cvs/" + path + ",v");
        this.mFullPath = this.mRealFile.getAbsoluteFile().getPath().replace('\\', '/');
    }

    public void testExpansionTypes() throws Exception {
        this.assertExpansion("$Author: matt $", "$Author$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$Author: matt $", "$Author$", KeywordExpansion.KFLAG_KVL);
        this.assertExpansion("$Author$", "$Author$", KeywordExpansion.KFLAG_K);
        this.assertExpansion("matt", "$Author$", KeywordExpansion.KFLAG_V);
        this.assertExpansion("$Author: foo $", "$Author: foo $", KeywordExpansion.KFLAG_O);
        this.assertExpansion("$Author: foo $", "$Author: foo $", KeywordExpansion.KFLAG_B);
        this.assertExpansion("$Author: matt $$Author: matt $", "$Author$$Author: d$", KeywordExpansion.KFLAG_KV);
    }

    public void testKeywordTypes() throws Exception {
        this.assertExpansion("$Author: matt $", "$Author$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$Date: 2004/08/23 00:53:55 $", "$Date$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$Name:  $", "$Name$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$RCSfile: file.txt,v $", "$RCSfile$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$Revision: 1.2 $", "$Revision$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$Source: " + this.mFullPath + " $", "$Source$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$State: Exp $", "$State$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$Id: file.txt,v 1.2 2004/08/23 00:53:55 matt Exp $", "$Id$", KeywordExpansion.KFLAG_KV);
        this.assertExpansion("$Header: " + this.mFullPath + " 1.2 2004/08/23 00:53:55 matt Exp $", "$Header$", KeywordExpansion.KFLAG_KV);
    }

    public void testNameExpansion() throws Exception {
        this.symrev = null;
        this.assertExpansion("$Name:  $", "$Name$", KeywordExpansion.KFLAG_KV);
        this.symrev = "1.2";
        this.assertExpansion("$Name:  $", "$Name$", KeywordExpansion.KFLAG_KV);
        this.symrev = "TAG1";
        this.assertExpansion("$Name: TAG1 $", "$Name$", KeywordExpansion.KFLAG_KV);
    }

    public void testEdgecases() throws Exception {
        KeywordExpansion m = KeywordExpansion.KFLAG_K;
        this.assertExpansion("abc", "abc", m);
        this.assertExpansion("$Name$", "$Name$", m);
        this.assertExpansion("$Name$", "$Name:$", m);
        this.assertExpansion("a$Name$", "a$Name: foo$", m);
        this.assertExpansion("a$Name$b", "a$Name: foo$b", m);
        this.assertExpansion("a$Name$b", "a$Name: foo$b", m);
        this.assertExpansion("$Name: foo", "$Name: foo", m);
        this.assertExpansion("$bar$Name$", "$bar$Name: foo$", m);
        this.assertExpansion("$Name$Name$", "$Name: foo$Name: foo$", m);
        this.assertExpansion("$Name$ $Author$", "$Name: foo$ $Author: bar$", m);
        this.assertExpansion("$Name$$Author$", "$Name: foo$$Author: bar$", m);
    }

    public void testEscapes() throws Exception {
        this.mRealFile = new File("/foo/bar\t\n $bar.txt,v");
        this.assertExpansion("$RCSfile: bar\\t\\n\\040\\044bar.txt,v $", "$RCSfile$", KeywordExpansion.KFLAG_KV);
    }

    public void DISABLEDtestLog() throws Exception {
        this.mRcsInfo.setComment("comment1");
        this.assertExpansion(new String[]{"$Log: file.txt,v $", "Revision 1.2  2004/08/23 00:53:55  matt", "comment1", "LastLineInFile"}, new String[]{"$Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment1");
        this.assertExpansion(new String[]{"$Log: file.txt,v $", "Revision 1.2  2004/08/23 00:53:55  matt", "comment1LastLineInFile"}, new String[]{"$Log$LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment2\n");
        this.assertExpansion(new String[]{"$Log: file.txt,v $", "Revision 1.2  2004/08/23 00:53:55  matt", "comment2", "", "LastLineInFile"}, new String[]{"$Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment2\n");
        this.assertExpansion(new String[]{"$Log: file.txt,v $", "Revision 1.2  2004/08/23 00:53:55  matt", "comment2", "LastLineInFile"}, new String[]{"$Log$LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment3\nline2");
        this.assertExpansion(new String[]{"$Log: file.txt,v $", "Revision 1.2  2004/08/23 00:53:55  matt", "comment3", "line2", "LastLineInFile"}, new String[]{"$Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment3\nline2\n");
        this.assertExpansion(new String[]{"$Log: file.txt,v $", "Revision 1.2  2004/08/23 00:53:55  matt", "comment3", "line2", "", "LastLineInFile"}, new String[]{"$Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
    }

    public void DISABLEDtestLogLeading() throws Exception {
        this.mRcsInfo.setComment("comment1");
        this.assertExpansion(new String[]{"* $Log: file.txt,v $", "* Revision 1.2  2004/08/23 00:53:55  matt", "* comment1", "LastLineInFile"}, new String[]{"* $Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment1");
        this.assertExpansion(new String[]{"* $Log: file.txt,v $", "* Revision 1.2  2004/08/23 00:53:55  matt", "* comment1LastLineInFile"}, new String[]{"* $Log$LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment2\n");
        this.assertExpansion(new String[]{"* $Log: file.txt,v $", "* Revision 1.2  2004/08/23 00:53:55  matt", "* comment2", "* ", "LastLineInFile"}, new String[]{"* $Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment2\n");
        this.assertExpansion(new String[]{"* $Log: file.txt,v $", "* Revision 1.2  2004/08/23 00:53:55  matt", "* comment2", "* LastLineInFile"}, new String[]{"* $Log$LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment3\nline2");
        this.assertExpansion(new String[]{"* $Log: file.txt,v $", "* Revision 1.2  2004/08/23 00:53:55  matt", "* comment3", "* line2", "LastLineInFile"}, new String[]{"* $Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
        this.mRcsInfo.setComment("comment3\nline2\n");
        this.assertExpansion(new String[]{"* $Log: file.txt,v $", "* Revision 1.2  2004/08/23 00:53:55  matt", "* comment3", "* line2", "* ", "LastLineInFile"}, new String[]{"* $Log$", "LastLineInFile"}, KeywordExpansion.KFLAG_KV);
    }

    private void assertExpansion(String expected, String input, KeywordExpansion mode) throws IOException {
        this.assertExpansion(new String[]{expected + "\n"}, new String[]{input}, mode);
    }

    private void assertExpansion(String[] expecteds, String[] input, KeywordExpansion mode) throws IOException {
        String expected = "";
        for (int i = 0; i < expecteds.length; ++i) {
            String s = expecteds[i];
            expected = expected + s + (i == expecteds.length - 1 ? "" : "\n");
        }
        StringBuffer buf = new StringBuffer();
        LineWriter out = buf::append;
        KeywordExpandingLineWriter e = new KeywordExpandingLineWriter(mode, this.mRealFile, this.mRcsInfo.makeKeywordExpansionInfo(this.symrev), out);
        for (String line : input) {
            e.writeLine(line + "\n");
        }
        String result = buf.toString();
        KeywordExpanderTest.assertEquals((String)expected, (String)result);
    }
}

