/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.FisheyeContextLoader;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class FisheyeSanityTestBase {
    protected RepositoryEngine engine;
    protected RepositoryHandle handle;
    protected ReviewManager reviewManager;
    protected RepositoryManager repositoryManager;
    protected UserPermissionsTestRule userPermissionsTestRule;

    public static void fisheyeSetUp() throws Exception {
        Disposer.pushThreadInstance();
        FisheyeContextLoader.contextConfigurationResources = "classpath:com/atlassian/fisheye/webspringcontext/webTestApplicationContext.xml;WEB-INF/applicationContext.xml";
    }

    public static void fisheyeTearDown() throws Exception {
        FisheyeContextLoader.contextConfigurationResources = null;
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    protected abstract RepositoryHandle whichHandle() throws Exception;

    @Before
    public void setUp() throws Exception {
        this.handle = this.whichHandle();
        this.engine = this.handle.acquireEngine();
        this.reviewManager = (ReviewManager)SpringContext.getComponentByClass(ReviewManager.class);
        Assert.assertNotNull((String)"reviewManager set up properly", (Object)this.reviewManager);
        this.repositoryManager = (RepositoryManager)SpringContext.getComponentByClass(RepositoryManager.class);
        Assert.assertNotNull((String)"repositoryManager set up properly", (Object)this.repositoryManager);
        this.userPermissionsTestRule = (UserPermissionsTestRule)((Object)SpringContext.createComponent(UserPermissionsTestRule.class));
        this.userPermissionsTestRule.before();
    }

    @After
    public void tearDown() throws Exception {
        this.userPermissionsTestRule.after();
        HibernateUtil.forceRollbackTransaction();
        HibernateUtil.closeSession();
    }

    protected void assertResultsContain(String path, String rev, SearchResults collator) throws Exception {
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        while (results.hasNext()) {
            FileRevision info = results.nextItem();
            if (!path.equals(info.getPath().toString()) || !rev.equals(info.getRevision())) continue;
            return;
        }
        System.out.println("could not find " + rev + " in ");
        this.dumpResults(collator);
        junit.framework.Assert.fail((String)("could not find " + rev));
    }

    protected void assertResultsSize(int expected, SearchResults results) throws Exception {
        int size = results.size();
        if (expected != size) {
            System.out.println("Found instead:");
            this.dumpResults(results);
        }
        junit.framework.Assert.assertEquals((int)expected, (int)size);
    }

    private void dumpResults(SearchResults results) throws DbException {
        SearchResults.RevisionResultsIterator i = results.iterateRevisions(0);
        while (i.hasNext()) {
            FileRevision fi = i.next();
            System.out.println(" " + fi.getRevInfoKey() + "  " + fi.getRevID());
        }
    }

    protected SearchResults doQuery(String ql) throws Exception {
        return FisheyeSanityTestBase.doQuery(ql, this.engine);
    }

    public static SearchResults doQuery(String ql, RepositoryEngine engine) throws Exception {
        ArrayList errors = new ArrayList();
        FishQuery fq = FishQuery.parse((String)ql, errors);
        if (!errors.isEmpty()) {
            System.out.println(errors);
        }
        junit.framework.Assert.assertTrue((boolean)errors.isEmpty());
        System.out.println("q= " + fq.makeQueryString());
        SearchManager searchManager = engine.getSearchManager();
        return searchManager.runQuery(fq, true);
    }
}

