/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.ChangeTree;
import com.cenqua.fisheye.cvsrep.KeywordExpandingLineWriter;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.LineWriter;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.RevisionEdge;
import com.cenqua.fisheye.cvsrep.RevisionExtractor;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class DiffTextExtractorTest
extends TestCase {
    private static File DIR = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/complex");

    public void testHeadTextSimple() throws IOException, RCSParser.ParseException {
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/simple/simple1.txt,v"));
        Charset cs = Charset.defaultCharset();
        Path path = new Path((CharSequence)"");
        RcsFileHistoryFactory.Result result = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)cs, (Path)path);
        ChangeTree tree = result.getTree();
        tree.initFileStream();
        Reader reader = tree.getHeadTextReader();
        String text = IOHelper.copyReaderToString((Reader)reader);
        tree.closeFileStream();
        DiffTextExtractorTest.assertEquals((String)text, (String)"this is a simple file");
    }

    public void testHeadTextBranches() throws IOException, RCSParser.ParseException, ChangeTree.DiffTextException {
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(new File(DIR, "test.txt,v"));
        Charset cs = Charsets.UTF_8;
        Path path = new Path((CharSequence)"");
        RcsFileHistoryFactory.Result result = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)cs, (Path)path);
        for (RcsRevisionInfo rev : result.getHistory().getRevisions()) {
            File tmp = FisheyeTestUtil.createTempFile("test_" + rev.getRevision() + ".txt");
            this.saveRevToFile(result, rev.getCvsRevision(), "test.txt,v", tmp);
            FileReader r = new FileReader(tmp);
            this.assertRevEqualsFile(rev.getRevision(), r, "test_" + rev.getRevision() + ".txt");
            ((Reader)r).close();
        }
        ChangeTree tree = result.getTree();
        tree.initFileStream();
        this.assertRevEqualsFile("head", tree.getHeadTextReader(), "test_head.txt");
        for (RcsRevisionInfo rev : result.getHistory().getRevisions()) {
            this.assertRevEqualsFile(rev.getRevision(), tree.getRevisionReader(rev.getCvsRevision()), "test_" + rev.getRevision() + ".txt");
        }
        tree.closeFileStream();
    }

    public void testLongBranches() throws IOException, RCSParser.ParseException, ChangeTree.DiffTextException {
        File dir = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/changetree/");
        String[] files = new String[]{"ServerPipeAssemblerContext.java,v", "LocalTransportPipe.java,v", "ClientPipeAssemblerContext.java,v"};
        String[] longRevisions = new String[]{"1.1.2.4.2.17.2.1", "1.1.2.17.2.4", "1.1.2.5.2.14.2.1"};
        for (int i = 0; i < files.length; ++i) {
            RcsFileHistoryFactory.Result result = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)new BufferedRandomAccessInputStream(new File(dir, files[i])), (Charset)Charset.forName("utf8"), (Path)Path.ROOT);
            Revision head = new Revision(result.getHistory().getHead());
            Revision target = new Revision(longRevisions[i]);
            List path = result.getTree().getEdgeList(target, head);
            this.assertValidDiffPath(head, target, path);
        }
    }

    private void assertValidDiffPath(Revision head, Revision target, List<RevisionEdge> path) {
        if (head.equals((Object)target)) {
            DiffTextExtractorTest.assertTrue((boolean)path.isEmpty());
        } else {
            DiffTextExtractorTest.assertEquals((Object)path.get(0).getFrom(), (Object)head);
            DiffTextExtractorTest.assertEquals((Object)path.get(path.size() - 1).getTo(), (Object)target);
            Revision expectedFrom = head;
            for (RevisionEdge edge : path) {
                DiffTextExtractorTest.assertEquals((Object)edge.getFrom(), (Object)expectedFrom);
                expectedFrom = edge.getTo();
            }
        }
    }

    public void testAllCvs() throws IOException {
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.push(new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/"));
        dirs.push(new File(FisheyeTestEnv.WORKSPACE_DIR, "output/tmp/"));
        HashSet<File> expectedParseErrors = new HashSet<File>();
        expectedParseErrors.add(new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU502/xercesImpl.jar,v"));
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.pop();
            Logs.APP_LOG.debug((Object)("searching " + dir));
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    dirs.push(file);
                    continue;
                }
                if (!file.getName().endsWith(",v")) continue;
                try {
                    Logs.APP_LOG.debug((Object)("testing " + file));
                    this.assertAllDiffPathsValid(file);
                }
                catch (RCSParser.ParseException e) {
                    if (expectedParseErrors.contains(file)) continue;
                    DiffTextExtractorTest.fail();
                }
            }
        }
    }

    private void assertAllDiffPathsValid(File file) throws IOException, RCSParser.ParseException {
        RcsFileHistoryFactory.Result result = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)new BufferedRandomAccessInputStream(file), (Charset)Charset.forName("utf8"), (Path)Path.ROOT);
        RcsFileHistory history = result.getHistory();
        ChangeTree tree = result.getTree();
        for (RcsRevisionInfo rev : history.getRevisions()) {
            Revision head = new Revision(history.getHead());
            try {
                this.assertValidDiffPath(head, rev.getCvsRevision(), tree.getEdgeList(rev.getCvsRevision(), head));
            }
            catch (ChangeTree.DiffTextException e) {
                Logs.APP_LOG.debug((Object)("Error processing revision " + rev + ", file " + file));
                e.printStackTrace();
                DiffTextExtractorTest.fail();
            }
        }
    }

    private void saveRevToFile(RcsFileHistoryFactory.Result result, Revision rev, String inputFilename, File outputFile) throws IOException, RCSParser.ParseException {
        StringBuffer buf = new StringBuffer();
        LineWriter out = buf::append;
        File f = new File(DIR, inputFilename);
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(new File(DIR, inputFilename));
        KeywordExpansion.KeywordExpansionInfo ki = result.getHistory().getCvsRevision(rev.toString()).makeKeywordExpansionInfo();
        KeywordExpandingLineWriter keWriter = new KeywordExpandingLineWriter(KeywordExpansion.KFLAG_KV, f, ki, out);
        RevisionExtractor.extractRevision((BufferedRandomAccessInputStream)in, (Charset)Charsets.UTF_8, (Revision)rev, (LineWriter)keWriter);
        IOHelper.copyCharSequenceToFile((CharSequence)buf, (Charset)Charsets.UTF_8, (File)outputFile);
    }

    private void assertRevEqualsFile(String rev, Reader reader, String s) throws IOException {
        String text = reader != null ? IOHelper.copyReaderToString((Reader)reader) : "";
        String expected = IOHelper.copyFileToString((Charset)Charsets.UTF_8, (File)new File(DIR, s));
        DiffTextExtractorTest.assertEquals((String)rev, (String)expected, (String)text);
    }
}

