/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.atlassian.event.api.EventPublisher;
import com.cenqua.crucible.util.DummyEventPublisher;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.RepositoryModificationTracker;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.config.IndexingConfig;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexerCache;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.mockito.Mockito;

public class CvsTestUtil {
    private static final String REPO_NAME = "test";
    private static final IndexingConfig indexingConfig = new IndexingConfig(){
        private final RepositoryStatus status = new RepositoryStatus("test");

        public boolean isContentIndexingEnabled() {
            return true;
        }

        public long getMaxIndexableSize() {
            return 102400L;
        }

        public boolean isOfIndexableSize(Path path, long size, String revision) {
            return true;
        }

        public RepositoryStatus getStatus() {
            return this.status;
        }
    };

    public static CvsCache makeRevisionCache(File cvsroot) throws Exception {
        return CvsTestUtil.makeRevisionCache(cvsroot, CvsScmConfig.DEFAULT_CVS_ENCODING);
    }

    public static CvsCache makeRevisionCache(File cvsroot, Charset cs) throws Exception {
        CvsRepository rep = new CvsRepository(REPO_NAME, new AllowRules(new ArrayList(), new ArrayList()), cvsroot, cs);
        LuceneConnection idx0 = new LuceneConnection(FisheyeTestUtil.createTempFile("fisheye"), (Analyzer)new SimpleAnalyzer(), (LuceneConnection.IndexConfig[])LuceneIndexes.activeValues());
        NullLicenseEnforcer licenseEnforcer = new NullLicenseEnforcer();
        File cachedir = FisheyeTestUtil.createTempDir("fisheye");
        InfinityDbHandle dbh = new InfinityDbHandle(new File(cachedir, "data.bin"));
        CrossRepLuceneIndex crossRepLuceneIndex = new CrossRepLuceneIndex(cachedir);
        IndexingContext indexingContext = new IndexingContext(crossRepLuceneIndex, null, null, false, (RepositoryModificationTracker)Mockito.mock(RepositoryModificationTracker.class), new PathIndexer(crossRepLuceneIndex, new PathIndexerCache((EventPublisher)new DummyEventPublisher())), new BranchIndexer(crossRepLuceneIndex));
        InfDbRevisionInfoCache db = new InfDbRevisionInfoCache((RepositoryConfig)Mockito.mock(RepositoryConfig.class), indexingContext, dbh, (LicenseEnforcer)licenseEnforcer);
        db.open();
        CvsTestUtil.fudgeScan(db, rep, Path.ROOT);
        return new CvsCache(-1L, -1, (RevisionInfoCache)db, idx0, rep, indexingConfig, new CommonIndexer(), (LicenseEnforcer)licenseEnforcer, null, indexingContext, new RepositoryStatus(REPO_NAME));
    }

    private static void fudgeScan(InfDbRevisionInfoCache db, CvsRepository rep, Path path) throws Exception {
        Path[] subdirs;
        Path[] files = rep.listFiles(path);
        LinkedList<RcsFileHistoryFactory.Result> hists = new LinkedList<RcsFileHistoryFactory.Result>();
        for (Path file : files) {
            RcsFileHistory hist = rep.getFileHistoryInfo(file);
            hists.add(new RcsFileHistoryFactory.Result(null, hist));
        }
        db.index(hists);
        db.commit();
        for (Path dir : subdirs = rep.listDirs(path)) {
            CvsTestUtil.fudgeScan(db, rep, dir);
        }
    }
}

