/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.cvsrep.CvsRepositoryEngine;
import com.cenqua.fisheye.cvsrep.CvsTestHarness;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import org.junit.After;
import org.junit.Before;

public abstract class CvsTestBase
extends SpringIntegrationTestBase {
    protected CvsTestHarness testHarness;
    protected CvsCache cache;

    @Before
    public void setUp() throws Exception {
        AppConfig.setTestMode();
        this.testHarness = this.createHarness();
        AppConfig.getsConfig().initCrossRepLuceneIndex();
        this.testHarness.setAllow(this.getAllowRules());
        this.testHarness.setStoreDiffs(this.getStoreDiffs());
        this.testHarness.setCharset(this.getCharset());
        String dumpFile = "test/testfiles/cvs/" + this.getDumpName() + ".zip";
        File dump = new File(FisheyeTestEnv.WORKSPACE_DIR, dumpFile);
        this.testHarness.slurpDump(dump);
        this.testHarness.assertNoSlurpErrors(dumpFile);
        this.cache = ((CvsRepositoryEngine)this.testHarness.getEngine()).getRevisionCache();
    }

    protected CvsTestHarness createHarness() {
        return new CvsTestHarness();
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.cleanUp();
    }

    private boolean getStoreDiffs() {
        return true;
    }

    private AllowType getAllowRules() {
        return null;
    }

    private String getCharset() {
        return null;
    }

    public CvsCache getCache() {
        return this.cache;
    }

    protected abstract String getDumpName();
}

